/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client;

import java.io.File;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRebelNativeAgent {
    public static final String NATIVE_AGENT_PATTERN = ".*(libjrebel|jrebel32\\.dll|jrebel64\\.dll).*";
    private final File libFolder;

    public JRebelNativeAgent(File libFolder) {
        this.libFolder = libFolder;
    }

    public Maybe<File> agentLibForCurrentOS(boolean vm64bit) {
        String libName = null;
        if (EnvironmentUtil.isLinux()) {
            libName = vm64bit ? "libjrebel64.so" : "libjrebel32.so";
        } else if (EnvironmentUtil.isWindows()) {
            libName = vm64bit ? "jrebel64.dll" : "jrebel32.dll";
        } else if (EnvironmentUtil.isMac()) {
            String string = libName = vm64bit ? "libjrebel64.dylib" : "libjrebel32.dylib";
        }
        if (libName != null) {
            File libFile = new File(this.libFolder, libName);
            return libFile.isFile() ? Maybe.some(libFile) : Maybe.none();
        }
        return Maybe.none();
    }

    public File getClientJar() {
        return new File(this.libFolder, "jrebel-config-client-fat.jar");
    }
}

