/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.args;

import java.io.File;
import org.zeroturnaround.common.Pair;
import org.zeroturnaround.common.args.Arg;
import org.zeroturnaround.common.args.ArgOpaque;
import org.zeroturnaround.common.args.ArgTriple;
import org.zeroturnaround.common.options.Option;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebelArgs {
    public static ArgOpaque NOVERIFY = Arg.simple("-noverify");
    public static ArgTriple<String> SHARECLASSES_NONE = Arg.triple("-Xshareclasses", ":", "none").withValuesMatching("none");

    public static ArgTriple<String> configFile(JRebelConfiguration config) {
        return Arg.propertyWithPath("rebel.properties", config.getConfigurationFile());
    }

    public static ArgTriple<String> agent(File rebelJar) {
        return Arg.tripleWithPath("-javaagent", ":", rebelJar).withValuesMatching(".*jrebel\\.jar");
    }

    public static ArgTriple<Pair<String, String[]>> nativeAgent(File rebelLib) {
        return Arg.agentWithPaths("-agentpath", ":", rebelLib, new File[0]).withValuesMatching(".*(libjrebel|jrebel32\\.dll|jrebel64\\.dll).*");
    }

    public static ArgTriple<String[]> bootClasspath(File ... cp) {
        return Arg.tripleWithPaths("-Xbootclasspath/p", ":", cp).withValuesMatching(".*jrebel.*bootstrap.*");
    }

    public static ArgTriple<String> notificationUrl(String url) {
        return Arg.property("rebel.notification.url", url);
    }

    public static ArgTriple<String> rebelLog(JRebelConfiguration config) {
        return Arg.option(config.rebelLog());
    }

    public static ArgTriple<String> rebelLogDebug() {
        return Arg.property("rebel.log", "true");
    }

    public static ArgTriple<String> logFile(JRebelConfiguration config) {
        return Arg.optionWithPath((Option)config.logFile());
    }

    public static ArgTriple<String> rebelWorkspacePath(File path) {
        return Arg.propertyWithPath("rebel.workspace.path", path);
    }

    public static ArgTriple<String> rebelEnvIde(String id) {
        return Arg.property("rebel.env.ide", id);
    }

    public static ArgTriple<String> rebelEnvIdeProduct(String product) {
        return Arg.property("rebel.env.ide.product", product);
    }

    public static ArgTriple<String> rebelEnvIdeVersion(String version) {
        return Arg.property("rebel.env.ide.version", version);
    }

    public static ArgTriple<String> rebelMetadataPath(File path) {
        return Arg.propertyWithPath("rebel.metadata.path", path);
    }

    public static ArgTriple<String> httpProxyHost(String host) {
        return Arg.property("http.proxyHost", host);
    }

    public static ArgTriple<String> httpProxyPort(String port) {
        return Arg.property("http.proxyPort", port);
    }

    public static ArgTriple<String> httpNonProxyHosts(String hosts) {
        return Arg.property("http.nonProxyHosts", hosts);
    }
}

