/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.bootstrap;

import java.io.File;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.bootstrap.BootstrapCache;
import org.zeroturnaround.jrebel.client.bootstrap.BootstrapKey;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

public class JRebelBootstrapUtil {
    public static final String JREBEL_BOOTSTRAP_GENERATED_FILENAME_PREFIX = "_jrebel_bootstrap_";
    private static final String JREBEL_BOOTSTRAP_JAR = "jrebel-bootstrap.jar";

    public static String getBootstrapPath(JRebel jrebel, JavaVM jvm, ProgressMonitor monitor) throws Exception {
        monitor.subTask("Looking up JRebel bootstrap jar");
        BootstrapCache cache = new BootstrapCache(jrebel);
        String javaVersion = jvm.getDetailedVersion();
        if (javaVersion == null) {
            String bootstrapPath = JRebelBootstrapUtil.generateBootstrap(jrebel, jvm, monitor);
            JRebelClientAdapter.getInstance().info("Generated JRebel bootstrap jar: " + bootstrapPath);
            return bootstrapPath;
        }
        BootstrapKey key = new BootstrapKey(jrebel.getImplementationVersion(), javaVersion);
        if (cache.containsKey(key)) {
            String bootstrapPath = cache.get(key);
            if (!new File(bootstrapPath).exists()) {
                bootstrapPath = JRebelBootstrapUtil.generateBootstrap(jrebel, jvm, monitor);
                JRebelClientAdapter.getInstance().info("Generated JRebel bootstrap jar: " + bootstrapPath);
                cache.put(key, bootstrapPath);
            }
            return bootstrapPath;
        }
        String bootstrapPath = JRebelBootstrapUtil.generateBootstrap(jrebel, jvm, monitor);
        JRebelClientAdapter.getInstance().info("Generated JRebel bootstrap jar: " + bootstrapPath);
        cache.put(key, bootstrapPath);
        return bootstrapPath;
    }

    private static String generateBootstrap(final JRebel jrebel, final JavaVM jvm, ProgressMonitor monitor) throws Exception {
        File bootstrapDir = jrebel.getBootstrapCacheDir();
        if (!bootstrapDir.exists()) {
            bootstrapDir.mkdirs();
        }
        return monitor.syncExecLongRunningSubTask("Generating new JRebel bootstrap jar", new ProgressMonitor.Task<String, Exception>(){

            @Override
            public String run(ProgressMonitor monitor) throws Exception {
                return jrebel.isGriffin() ? JRebelBootstrapUtil.generateGriffinBootstrap(jrebel, jvm) : JRebelBootstrapUtil.generateJRebelBootstrap(jrebel, jvm);
            }
        });
    }

    private static String generateGriffinBootstrap(JRebel jrebel, JavaVM jvm) throws Exception {
        String bootstrapDir = jrebel.getBootstrapCacheDir().getAbsolutePath();
        String uniqueFilename = JRebelBootstrapUtil.getUniqueFilename();
        String bootstrapPath = bootstrapDir + File.separator + uniqueFilename;
        SafeExec.ExecResult result = new SafeExec("UTF-8").exec(jvm.pathToJavaExe(), "-Drebel.griffin.bootstrap_run=true", "-Drebel.griffin.bootstrap_path=" + bootstrapPath, "-javaagent:" + jrebel.getJarFile().getAbsolutePath(), "com.zeroturnaround.Dummy");
        boolean generationSucceeded = false;
        if (result.exitCode != 0) {
            JRebelClientAdapter.getInstance().error("Bootstrap generator exited with error code " + result.exitCode + ", output from command was:\n" + result.output + "\n\nError stream output was:\n" + result.errorOutput);
        } else {
            JRebelClientAdapter.getInstance().info("Bootstrap generator output was:\n" + result.output + "\n\nError stream output was:\n" + result.errorOutput);
            generationSucceeded = true;
        }
        if (!generationSucceeded) {
            throw JRebelClientAdapter.getInstance().newException("Bootstrap generation failed!");
        }
        return bootstrapPath;
    }

    private static String generateJRebelBootstrap(JRebel jrebel, JavaVM jvm) throws Exception {
        boolean generationSucceeded = false;
        try {
            String[] vmArgs = new String[]{"-Drebel.metadata.path=" + jrebel.getBootstrapCacheDir()};
            SafeExec.ExecResult result = jrebel.getCoreInterface(jvm.pathToJavaExe()).executeCoreCommand(vmArgs, new String[0]);
            if (result.exitCode != 0) {
                JRebelClientAdapter.getInstance().error("Bootstrap generator exited with error code " + result.exitCode + ", output from command was:\n" + result.output + "\n\nError stream output was:\n" + result.errorOutput);
            } else {
                JRebelClientAdapter.getInstance().info("Bootstrap generator output was:\n" + result.output + "\n\nError stream output was:\n" + result.errorOutput);
                generationSucceeded = true;
            }
        }
        catch (Exception e) {
            JRebelClientAdapter.getInstance().error(e);
        }
        String bootstrapDir = jrebel.getBootstrapCacheDir().getAbsolutePath();
        String uniqueFilename = JRebelBootstrapUtil.getUniqueFilename();
        String originalFilePath = bootstrapDir + File.separator + JREBEL_BOOTSTRAP_JAR;
        String newFilePath = bootstrapDir + File.separator + uniqueFilename;
        File originalFile = new File(originalFilePath);
        File destinationFile = new File(newFilePath);
        boolean renameSucceeded = originalFile.renameTo(destinationFile);
        if (generationSucceeded && !renameSucceeded) {
            JRebelClientAdapter.getInstance().error("[bootstrap generator] Failed to rename '" + originalFilePath + "' to '" + newFilePath + "'");
        }
        if (!generationSucceeded || !renameSucceeded) {
            throw JRebelClientAdapter.getInstance().newException("Bootstrap generation failed!");
        }
        return newFilePath;
    }

    private static String getUniqueFilename() {
        StringBuilder sb = new StringBuilder();
        sb.append(JREBEL_BOOTSTRAP_GENERATED_FILENAME_PREFIX);
        sb.append(System.currentTimeMillis());
        sb.append(".jar");
        return sb.toString();
    }
}

