/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.common;

import java.util.Locale;
import org.zeroturnaround.common.Maybe;

public class EnvironmentUtil {
    private static final String OS_NAME = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH);
    private static final String OS_ARCH = System.getProperty("os.arch", "");

    public static boolean isWindows() {
        return OS_NAME.startsWith("win");
    }

    public static boolean isLinux() {
        return OS_NAME.startsWith("linux");
    }

    public static boolean isMac() {
        return OS_NAME.startsWith("mac");
    }

    public static boolean is64Bit() {
        return OS_ARCH.contains("64");
    }

    public static boolean is64Bit(String osArch) {
        return Maybe.nullable(osArch).getOrElse(OS_ARCH).contains("64");
    }
}

