/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.config;

import com.zeroturnaround.jrebel.conf.bus.plugin.PluginInfo;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.zeroturnaround.common.options.ComputedOption;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.common.options.InvertedBooleanOption;
import org.zeroturnaround.common.options.Option;
import org.zeroturnaround.jrebel.client.common.JRebelCommon;
import org.zeroturnaround.jrebel.client.config.CustomPlugin;
import org.zeroturnaround.jrebel.client.config.CustomPropertyOption;
import org.zeroturnaround.jrebel.client.config.IPropertyChangedListener;
import org.zeroturnaround.jrebel.client.config.LogLevel;
import org.zeroturnaround.jrebel.client.config.Property;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRebelConfiguration {
    public static final String REBEL_PROPERTIES = "rebel.properties";
    private static final String REBEL_PROPERTIES_VERSION = "rebel.properties.version";
    private static final String DEFAULT_PROFILE_KEY = "jrebel";
    private static final Map<String, JRebelConfiguration> profiles = new HashMap<String, JRebelConfiguration>();
    private static final Set<String> HIDDEN_PROPERTIES = new HashSet<String>();
    private boolean initialized = false;
    private final String profileName;
    private volatile boolean loading = false;
    private volatile boolean disableScheduleSave = false;
    private final Map<String, Boolean> pluginEnablement = new HashMap<String, Boolean>();
    private final List<CustomPlugin> customPlugins = new ArrayList<CustomPlugin>();
    private final List<Property> customProperties = new ArrayList<Property>();
    private List<Option<?>> options;
    private final Option<File> licenseFile = Option.file("rebel.license");
    private final Option<Integer> avgRedeployTime = Option.intWithDefault("rebel.stats.time", 146);
    private final Option<Boolean> statisticsEnabled = Option.boolWithDefault("rebel.stats", true);
    private final Option<Boolean> disableUpdate = Option.boolWithDefault("rebel.disable_update", false);
    private final IOption<Boolean> updateChecksEnabled = new InvertedBooleanOption((IOption<Boolean>)this.disableUpdate);
    private final Option<Boolean> usageReportingEnabled = Option.boolWithDefault("rebel.usage_reporting", true);
    private final Option<File> logFile = Option.fileWithDefaultForceSave("rebel.log.file", new File(JRebelConfiguration.getConfigurationDirectory(), "jrebel.log"));
    private final Option<String> rebelLog = Option.stringWithDefault("rebel.log", "false");
    private final IOption<LogLevel> logLevel = new ComputedOption<LogLevel, String>(this.rebelLog){

        @Override
        public LogLevel apply(String value) {
            return LogLevel.fromPropertyValue(value);
        }

        @Override
        public String unapply(LogLevel value) {
            return value.propertyValue;
        }
    };
    private final Option<Boolean> performanceLogging = Option.boolWithDefault("rebel.log.perf", false);
    private final Option<Boolean> requestLogging = Option.boolWithDefault("rebel.log.request", false);
    private final Option<Boolean> consoleLogging = Option.boolWithDefault("rebel.log.stdout", true);
    private final Option<Integer> preferredLicense = Option.intWithDefault("rebel.preferred.license", 0);
    private final Option<String> licenseServerUrl = Option.stringWithDefault("rebel.license.url", null);
    private final Option<Boolean> passProxySettings = Option.boolWithDefault("rebel.ide.pass_proxy_settings", false);
    private final Option<Integer> offlineLeaseDuration = Option.intWithDefault("rebel.ide.offline_lease_duration", 7);
    private final IOption<Boolean> searchForWebInf = CustomPropertyOption.boolWithDefault(this, "rebel.ide.search_for_webinf", false);

    public JRebelConfiguration(String profileName) {
        this.profileName = profileName;
        this.preferredLicense.setWriteDefault(true);
        this.options = Arrays.asList(this.licenseFile, this.licenseServerUrl, this.preferredLicense, this.avgRedeployTime, this.statisticsEnabled, this.disableUpdate, this.usageReportingEnabled, this.logFile, this.rebelLog, this.performanceLogging, this.requestLogging, this.consoleLogging, this.passProxySettings, this.offlineLeaseDuration);
        for (Option<?> option : this.options) {
            option.addValueChangedListener(new IValueChangedListener<Object>(){

                @Override
                public void valueChanged(IOption<Object> option) {
                    JRebelConfiguration.this.scheduleSave();
                }
            });
        }
    }

    public void setDisableScheduleSave(boolean flag) {
        this.disableScheduleSave = flag;
    }

    public static File getConfigurationDirectory() {
        return JRebelCommon.getUserHomeDir();
    }

    public static File getDefaultLogFile() {
        return new File(JRebelCommon.getUserHomeDir(), "jrebel.log");
    }

    public static synchronized JRebelConfiguration getProfile(String profileName) {
        JRebelConfiguration profile = profiles.get(profileName);
        if (!profile.initialized) {
            profile.loadFromFile(profile.getConfigurationFile(), null);
            profile.initialized = true;
        }
        return profile;
    }

    public static JRebelConfiguration getDefault() {
        return JRebelConfiguration.getProfile(DEFAULT_PROFILE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCustomProperty(String key) {
        List<Property> list = this.customProperties;
        synchronized (list) {
            for (Property p : this.customProperties) {
                if (!p.getKey().equals(key)) continue;
                return p.getValue();
            }
            return null;
        }
    }

    public void reinit(File jrebelJarFile) {
        this.loadFromFile(this.getConfigurationFile(), jrebelJarFile);
        this.initialized = true;
    }

    public File getConfigurationFile() {
        return new File(JRebelConfiguration.getConfigurationDirectory(), this.profileName + ".properties");
    }

    public Option<Integer> avgRedeployTime() {
        return this.avgRedeployTime;
    }

    public IOption<Boolean> statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public IOption<Boolean> updateChecksEnabled() {
        return this.updateChecksEnabled;
    }

    public IOption<Boolean> usageReportingEnabled() {
        return this.usageReportingEnabled;
    }

    public IOption<Integer> preferredLicense() {
        return this.preferredLicense;
    }

    public Option<File> licenseFile() {
        return this.licenseFile;
    }

    public IOption<File> logFile() {
        return this.logFile;
    }

    public String getLogDir() {
        return this.logFile.getValueOrDefault().getParent();
    }

    public Option<String> rebelLog() {
        return this.rebelLog;
    }

    public IOption<LogLevel> logLevel() {
        return this.logLevel;
    }

    public IOption<Boolean> performanceLogging() {
        return this.performanceLogging;
    }

    public IOption<Boolean> requestLogging() {
        return this.requestLogging;
    }

    public IOption<Boolean> consoleLogging() {
        return this.consoleLogging;
    }

    public Option<String> licenseServerUrl() {
        return this.licenseServerUrl;
    }

    public Option<Boolean> passProxySettings() {
        return this.passProxySettings;
    }

    public Option<Integer> offlineLeaseDuration() {
        return this.offlineLeaseDuration;
    }

    public IOption<Boolean> searchForWebInf() {
        return this.searchForWebInf;
    }

    public List<Property> getCustomProperties() {
        return this.customProperties;
    }

    public Property addCustomProperty(String key, String value) {
        Property property = this.newCustomProperty(key, value);
        this.scheduleSave();
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property newCustomProperty(String key, String value) {
        Property property = new Property(key, value);
        property.addPropertyChangedListener(new IPropertyChangedListener(){

            public void propertyChanged(Property property) {
                JRebelConfiguration.this.scheduleSave();
            }
        });
        List<Property> list = this.customProperties;
        synchronized (list) {
            this.customProperties.add(property);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomProperty(Property property) {
        List<Property> list = this.customProperties;
        synchronized (list) {
            this.customProperties.remove(property);
        }
        this.scheduleSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomProperty(String key) {
        List<Property> list = this.customProperties;
        synchronized (list) {
            Iterator<Property> it = this.customProperties.iterator();
            while (it.hasNext()) {
                Property property = it.next();
                if (!property.getKey().equals(key)) continue;
                it.remove();
            }
        }
        this.scheduleSave();
    }

    public List<CustomPlugin> getCustomPlugins() {
        return this.customPlugins;
    }

    public boolean isPluginEnabled(PluginInfo plugin) {
        return this.pluginEnablement.containsKey(plugin.getId()) ? this.pluginEnablement.get(plugin.getId()).booleanValue() : plugin.isEnabledByDefault();
    }

    public void setPluginEnabled(String pluginId, boolean enabled) {
        if (pluginId != null) {
            this.pluginEnablement.put(pluginId, enabled);
            this.scheduleSave();
        }
    }

    public void setPluginEnabled(PluginInfo plugin, boolean enabled) {
        if (plugin.isEnabledByDefault() == enabled) {
            this.pluginEnablement.remove(plugin.getId());
        } else {
            this.pluginEnablement.put(plugin.getId(), enabled);
        }
        this.scheduleSave();
    }

    public void resetPluginEnablementToDefault() {
        this.pluginEnablement.clear();
        this.scheduleSave();
    }

    public void scheduleSave() {
        if (!this.loading && !this.disableScheduleSave) {
            JRebelClientAdapter.getInstance().asyncSaveConfiguration(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Properties saveProps = new Properties();
        saveProps.setProperty(REBEL_PROPERTIES_VERSION, "2");
        for (Option<?> option : this.options) {
            option.saveIn(saveProps);
        }
        if (this.customPlugins.size() > 0) {
            StringBuilder rebelPlugins = new StringBuilder();
            for (CustomPlugin plug : this.customPlugins) {
                if (rebelPlugins.length() > 0) {
                    rebelPlugins.append(",");
                }
                rebelPlugins.append(plug.file.getAbsolutePath());
                if (plug.enabled || plug.info == null || plug.info.getId() == null) continue;
                saveProps.setProperty("rebel." + plug.getInfo().getId(), "false");
            }
            saveProps.setProperty("rebel.plugins", rebelPlugins.toString());
        }
        for (Map.Entry entry : this.pluginEnablement.entrySet()) {
            saveProps.setProperty("rebel." + (String)entry.getKey(), ((Boolean)entry.getValue()).toString());
        }
        List<Property> i$ = this.customProperties;
        synchronized (i$) {
            if (this.customProperties.size() > 0) {
                for (Property prop : this.customProperties) {
                    saveProps.setProperty(prop.getKey(), prop.getValue());
                }
            }
        }
        FileOutputStream stream = null;
        try {
            File file = JRebelConfiguration.getConfigurationDirectory();
            if (!file.exists()) {
                file.mkdirs();
            }
            stream = new FileOutputStream(this.getConfigurationFile());
            saveProps.store(stream, "Saved by JRebel IDE Plugin");
            IOUtils.closeQuietly(stream);
        }
        catch (Exception exception) {
            JRebelClientAdapter.getInstance().error(exception);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile(File propertiesFile, File jrebelJarFile) {
        this.loading = true;
        try {
            Object elements;
            Properties props = new Properties();
            if (propertiesFile.exists()) {
                try {
                    props.load(new FileInputStream(propertiesFile));
                    props = this.replaceDashesWithUnderscore(props);
                }
                catch (Exception e) {
                    JRebelClientAdapter.getInstance().error(e);
                }
            }
            this.customPlugins.clear();
            String rebelPlugins = props.getProperty("rebel.plugins");
            if (rebelPlugins != null) {
                String[] customPluginsStr;
                props.remove("rebel.plugins");
                for (String customPluginStr : customPluginsStr = rebelPlugins.split(",")) {
                    String propKey;
                    String property;
                    CustomPlugin cp = new CustomPlugin(new File(customPluginStr), true);
                    if (cp.initializeFromFile() && (property = props.getProperty(propKey = "rebel." + cp.getInfo().getId())) != null) {
                        cp.enabled = "true".equals(property);
                        props.remove(propKey);
                    }
                    this.customPlugins.add(cp);
                }
            }
            for (Option<?> option : this.options) {
                option.loadFrom(props);
                props.remove(option.getName());
            }
            if (jrebelJarFile != null) {
                this.pluginEnablement.clear();
                Properties pluginProperties = PluginUtil.readPluginProperties(jrebelJarFile);
                if (pluginProperties != null) {
                    elements = pluginProperties.keys();
                    while (elements.hasMoreElements()) {
                        String id = (String)elements.nextElement();
                        String propKey = "rebel." + id;
                        String property = props.getProperty(propKey);
                        if (property == null) continue;
                        this.pluginEnablement.put(id, "true".equals(property));
                        props.remove(propKey);
                    }
                }
            }
            Enumeration<Object> keys = props.keys();
            elements = this.customProperties;
            synchronized (elements) {
                this.customProperties.clear();
            }
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (HIDDEN_PROPERTIES.contains(key)) continue;
                this.newCustomProperty(key, props.getProperty(key));
            }
        }
        finally {
            this.loading = false;
        }
    }

    private Properties replaceDashesWithUnderscore(Properties props) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (e.getKey().toString().endsWith("-plugin")) {
                if (e.getKey().equals("rebel.log4j-plugin")) {
                    result.put("rebel.log4j_plugin", e.getValue());
                    continue;
                }
                if (e.getKey().equals("rebel.struts1-plugin")) {
                    result.put("rebel.struts1_plugin", e.getValue());
                    continue;
                }
                if (e.getKey().equals("rebel.struts2-plugin")) {
                    result.put("rebel.struts2_plugin", e.getValue());
                    continue;
                }
                result.put(e.getKey(), e.getValue());
                continue;
            }
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    static {
        profiles.put(DEFAULT_PROFILE_KEY, new JRebelConfiguration(DEFAULT_PROFILE_KEY));
        HIDDEN_PROPERTIES.add(REBEL_PROPERTIES_VERSION);
    }
}

