/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.config;

import org.zeroturnaround.common.ListenerList;
import org.zeroturnaround.jrebel.client.config.IPropertyChangedListener;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

public class Property {
    private final ListenerList<IPropertyChangedListener> listeners = new ListenerList();
    private String key;
    private String value;

    public Property(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.notifyListeners();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.notifyListeners();
    }

    public void addPropertyChangedListener(IPropertyChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangedListener(IPropertyChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (IPropertyChangedListener listener : this.listeners.getListeners()) {
            try {
                listener.propertyChanged(this);
            }
            catch (Exception e) {
                JRebelClientAdapter.getInstance().error(e);
            }
        }
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

