/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.stats;

import java.util.concurrent.TimeUnit;

public class TimeAmount {
    private final long amount;
    private final TimeUnit unit;

    public TimeAmount(long amount, TimeUnit unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public long getAmount() {
        return this.amount;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public static TimeAmount create(long amount, TimeUnit unit) {
        return new TimeAmount(amount, unit);
    }

    public static TimeAmount days(long amount) {
        return TimeAmount.create(amount * 86400L, TimeUnit.SECONDS);
    }

    public static TimeAmount hours(long amount) {
        return TimeAmount.create(amount * 3600L, TimeUnit.SECONDS);
    }

    public static TimeAmount seconds(long amount) {
        return TimeAmount.create(amount, TimeUnit.SECONDS);
    }

    public static TimeAmount minutes(long amount) {
        return TimeAmount.create(amount * 60L, TimeUnit.SECONDS);
    }

    public static TimeAmount milliseconds(long amount) {
        return TimeAmount.create(amount, TimeUnit.MILLISECONDS);
    }

    public long toHours() {
        return this.unit.toSeconds(this.amount) / 3600L;
    }

    public long toMinutes() {
        return this.unit.toSeconds(this.amount) / 60L;
    }

    public long toSeconds() {
        return this.unit.toSeconds(this.amount);
    }

    public long toDays() {
        return this.unit.toSeconds(this.amount) / 86400L;
    }

    public long toMilliseconds() {
        return this.unit.toMillis(this.amount);
    }

    public void sleep() throws InterruptedException {
        this.unit.sleep(this.amount);
    }
}

