/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.util;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

public final class ShortFilenameUtil {
    private static final Pattern dirPattern = Pattern.compile("<(.+)>");

    public static String ifWindowsReplaceSpacesWithShortNames(String path) {
        if (EnvironmentUtil.isWindows()) {
            try {
                return ShortFilenameUtil.getShortFilenamePath(new File(path), true);
            }
            catch (Exception e) {
                JRebelClientAdapter.getInstance().error("Couldn't replace path names with short names in '" + path + "': " + e.getMessage());
                return path;
            }
        }
        return path;
    }

    public static String getShortFilenamePath(File path, boolean replaceOnlyIfSpaces) throws IOException {
        return ShortFilenameUtil.getShortFilenamePath(path, replaceOnlyIfSpaces, null);
    }

    private static String getShortFilenamePath(File path, boolean replaceOnlyIfSpaces, String remainder) throws IOException {
        if (path.getParent() == null) {
            return path.toString() + remainder;
        }
        String name = path.getName();
        String prefix = path.getParent();
        if (remainder == null && path.isFile()) {
            return ShortFilenameUtil.getShortFilenamePath(new File(prefix), replaceOnlyIfSpaces, name);
        }
        if (replaceOnlyIfSpaces && !name.contains(" ")) {
            String newRemainder = remainder == null ? name : name + File.separator + remainder;
            return ShortFilenameUtil.getShortFilenamePath(new File(prefix), replaceOnlyIfSpaces, newRemainder);
        }
        String shortFilename = ShortFilenameUtil.parseDirX(prefix, name);
        String newRemainder = remainder == null ? shortFilename : shortFilename + File.separator + remainder;
        return ShortFilenameUtil.getShortFilenamePath(new File(prefix), replaceOnlyIfSpaces, newRemainder);
    }

    private static String parseDirX(String prefix, String name) throws IOException {
        String output = SafeExec.execute((String[])new String[]{"cmd", "/C", "dir", "/X", prefix}).output;
        return ShortFilenameUtil.findShortDirName(name, output.split("\n"));
    }

    protected static String findShortDirName(String name, String[] lines) {
        for (String line : lines) {
            Matcher m = dirPattern.matcher(line);
            if (!m.find()) continue;
            int i = m.end(0);
            String dirNames = line.substring(i);
            String[] names = (dirNames = dirNames.replaceAll(" +", " ").trim()).split(" ", 2);
            if (!names[names.length - 1].equalsIgnoreCase(name)) continue;
            return names[0];
        }
        return name;
    }
}

