/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.config.gui;

import com.zeroturnaround.config.gui.component.FooterPane;
import com.zeroturnaround.config.gui.component.FromEvalPane;
import com.zeroturnaround.config.gui.component.FromFilePane;
import com.zeroturnaround.config.gui.component.FromLS2UrlPane;
import com.zeroturnaround.config.gui.component.FromMyJRebelPane;
import com.zeroturnaround.config.gui.component.HeaderPane;
import com.zeroturnaround.config.gui.component.LicenseCheckPane;
import com.zeroturnaround.config.gui.component.LicenseSelectionPane;
import com.zeroturnaround.config.gui.validate.LicenseValidator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GUI {
    private static HeaderPane header;
    private static CardLayout controller;
    private static JPanel contentHolder;
    private static LicenseSelectionPane licenseSelectionPane;
    private static LicenseCheckPane licenseCheckPane;
    private static FooterPane footer;
    private static final int width = 500;
    private static NavState curState;
    private static Map<NavState, LicenseValidator> validatorMap;
    public static boolean checkValid;

    public static void start() throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame main = GUI.createMainFrame();
        header = new HeaderPane(new Dimension(500, 30));
        controller = new CardLayout();
        contentHolder = new JPanel(controller);
        contentHolder.setBorder(new EmptyBorder(16, 16, 0, 16));
        footer = new FooterPane(500);
        main.add((Component)header, "North");
        main.add((Component)contentHolder, "Center");
        main.add((Component)footer, "South");
        licenseSelectionPane = new LicenseSelectionPane();
        contentHolder.add((Component)licenseSelectionPane, NavState.START.name());
        GUI.addLicensePane(new FromFilePane(), NavState.FROMFILE);
        GUI.addLicensePane(new FromLS2UrlPane(), NavState.FROMLS2URL);
        GUI.addLicensePane(new FromEvalPane(), NavState.FROMEVAL);
        GUI.addLicensePane(new FromMyJRebelPane(), NavState.FROMMYJREBEL);
        licenseCheckPane = new LicenseCheckPane();
        contentHolder.add((Component)licenseCheckPane, NavState.FINISH.name());
        main.pack();
        Dimension fixedWidth = new Dimension(500, (int)main.getSize().getHeight());
        main.setSize(fixedWidth);
        main.setVisible(true);
        main.setLocationRelativeTo(null);
        footer.focus();
        GUI.setState(NavState.START);
    }

    private static void addLicensePane(LicenseValidator pane, NavState state) {
        contentHolder.add((Component)((Object)pane), state.name());
        validatorMap.put(state, pane);
    }

    private static void setState(NavState state) {
        header.setText(state.headerText);
        controller.show(contentHolder, state.name());
        curState = state;
    }

    private static JFrame createMainFrame() throws Exception {
        JFrame main = new JFrame("JRebel Activation Wizard");
        main.setDefaultCloseOperation(3);
        main.setResizable(false);
        main.getContentPane().setLayout(new BorderLayout());
        BufferedImage ztLogo = ImageIO.read(GUI.class.getResourceAsStream("/zt_logo.png"));
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            Class<?> applicationClass = GUI.class.getClassLoader().loadClass("com.apple.eawt.Application");
            Method appMethod = applicationClass.getMethod("getApplication", new Class[0]);
            Method imageMethod = applicationClass.getMethod("setDockIconImage", Image.class);
            imageMethod.invoke(appMethod.invoke(null, new Object[0]), ztLogo);
        } else {
            main.setIconImage(ztLogo);
        }
        return main;
    }

    public static void handleNext() {
        switch (curState) {
            case START: {
                if (licenseSelectionPane.getSelectedNavState() == null) break;
                footer.setBackEnabled(true);
                GUI.setState(licenseSelectionPane.getSelectedNavState());
                break;
            }
            case FINISH: {
                System.exit(0);
                break;
            }
            default: {
                if (!validatorMap.get((Object)curState).infoComplete()) break;
                licenseCheckPane.checkLicense(validatorMap.get((Object)curState));
                footer.setFinish(true);
                GUI.setState(NavState.FINISH);
            }
        }
    }

    public static void handleBack() {
        if (curState != NavState.FINISH) {
            GUI.setState(NavState.START);
            footer.setBackEnabled(false);
            if (!checkValid) {
                licenseSelectionPane.startLicenseCheck();
            }
        } else {
            footer.setBackEnabled(true);
            footer.setNextEnabled(true);
            footer.setFinish(false);
            GUI.setState(licenseSelectionPane.getSelectedNavState());
        }
    }

    public static FooterPane getFooter() {
        return footer;
    }

    static {
        validatorMap = new HashMap<NavState, LicenseValidator>();
        checkValid = true;
    }

    public static enum NavState {
        START("Choose license"),
        FROMFILE("License File"),
        FROMLS2URL("License Server URL"),
        FROMMYJREBEL("myJRebel Setup"),
        FROMEVAL("14-Day Trial"),
        FINISH("License Check");

        public final String headerText;

        private NavState(String headerText) {
            this.headerText = headerText;
        }
    }
}

