/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.config.licensing;

import com.zeroturnaround.config.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Date;
import org.zeroturnaround.javarebel.Licensing;

public class LoggableLicensing {
    private static PrintWriter out = null;

    public static Licensing.SDKLicenseInfo getCurrentLicense() throws Licensing.ExpiredLicenseException {
        LoggableLicensing.log("----------------------------------------");
        LoggableLicensing.log("Getting current license...");
        try {
            return LoggableLicensing.logInfo(Config.getLicensing().getCurrentLicense());
        }
        catch (Licensing.ExpiredLicenseException e) {
            LoggableLicensing.logException(e);
            throw e;
        }
    }

    public static Licensing.SDKLicenseInfo activateFromKey(String license) throws Licensing.ActivationException, Licensing.ExpiredLicenseException {
        LoggableLicensing.log("----------------------------------------");
        LoggableLicensing.log("Activating with key: " + license);
        try {
            return LoggableLicensing.logInfo(Config.getLicensing().activateFromKey(license));
        }
        catch (Licensing.ActivationException e) {
            LoggableLicensing.logException(e);
            throw e;
        }
    }

    public static Licensing.SDKLicenseInfo activateFromFile(File license) throws Licensing.ActivationException, Licensing.ExpiredLicenseException {
        LoggableLicensing.log("----------------------------------------");
        LoggableLicensing.log("Activating with file: " + license.getAbsolutePath());
        try {
            return LoggableLicensing.logInfo(Config.getLicensing().activateFromFile(license));
        }
        catch (Licensing.ActivationException e) {
            LoggableLicensing.logException(e);
            throw e;
        }
    }

    private static Licensing.SDKLicenseInfo logInfo(Licensing.SDKLicenseInfo info) {
        LoggableLicensing.log("Received SDKLicenseInfo object:");
        for (Method method : Licensing.SDKLicenseInfo.class.getMethods()) {
            if (method.getParameterTypes().length != 0) continue;
            try {
                LoggableLicensing.log(method.getName() + "(): " + method.invoke((Object)info, new Object[0]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return info;
    }

    private static void logException(Licensing.ActivationException e) {
        LoggableLicensing.log("Received exception " + e.getClass().getSimpleName() + ":");
        for (Method method : Licensing.ActivationException.class.getDeclaredMethods()) {
            method.setAccessible(true);
            if (method.getParameterTypes().length != 0) continue;
            try {
                LoggableLicensing.log(method.getName() + "(): " + method.invoke((Object)e, new Object[0]));
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    private static void log(String line) {
        if (out != null) {
            out.println(String.format("[%1$tH:%1$tM:%1$tS] %2$s", new Date(), line));
        }
    }

    static {
        try {
            String logPath;
            File logFile;
            File jarLoc = new File(Config.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!jarLoc.isDirectory()) {
                jarLoc = jarLoc.getParentFile();
            }
            if (!(logFile = new File(logPath = jarLoc.getAbsolutePath() + File.separator + "jrebel-config.log")).exists()) {
                logFile.createNewFile();
            }
            out = new PrintWriter(new FileOutputStream(logFile, true), true);
            out.println();
            out.println("Starting session: " + new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

