/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMUtils {
    public static final String JAVA_FULLVERSION = "java.fullversion";
    public static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    public static final String JAVA_VERSION = "java.version";
    public static final String OS_ARCH = "os.arch";

    public static String getDetailedJavaVersion(String fullVersion, String runtimeVersion, String version, String osArch) {
        if (fullVersion != null) {
            fullVersion = fullVersion.replaceAll("enabled", "").replaceAll("disabled", "");
            fullVersion = fullVersion.replaceAll("Compressed References ", "");
            fullVersion = fullVersion.replaceAll("\nGC.*(\n|$)", "\n");
            return fullVersion + "_" + osArch;
        }
        if (runtimeVersion != null) {
            return runtimeVersion + "_" + osArch;
        }
        if (version != null) {
            return version + "_" + osArch;
        }
        return null;
    }

    public static String getDetailedJavaVersion(Map<String, String> props) {
        String fullVersion = props.get(JAVA_FULLVERSION);
        String runtimeVersion = props.get(JAVA_RUNTIME_VERSION);
        String version = props.get(JAVA_VERSION);
        String osArch = props.get(OS_ARCH);
        return JVMUtils.getDetailedJavaVersion(fullVersion, runtimeVersion, version, osArch);
    }

    public static Properties copySystemPropertiesForDetailedVersion() {
        Properties props = new Properties();
        JVMUtils.putIfNonNull(props, JAVA_FULLVERSION, System.getProperty(JAVA_FULLVERSION));
        JVMUtils.putIfNonNull(props, JAVA_RUNTIME_VERSION, System.getProperty(JAVA_RUNTIME_VERSION));
        JVMUtils.putIfNonNull(props, JAVA_VERSION, System.getProperty(JAVA_VERSION));
        JVMUtils.putIfNonNull(props, OS_ARCH, System.getProperty(OS_ARCH));
        return props;
    }

    private static void putIfNonNull(Map<Object, Object> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

