/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XPathServlet
extends HttpServlet {
    private SAXReader reader = new SAXReader();
    private OutputFormat outputFormat = new OutputFormat("  ", true);
    private XMLWriter writer;
    protected static final String XML_MIME_TYPE = "application/xml";

    public void init() throws ServletException {
    }

    public void destroy() {
        this.log("Destroyed");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType(XML_MIME_TYPE);
        try {
            if (this.writer == null) {
                this.writer = new XMLWriter(this.outputFormat);
            }
            this.writer.setOutputStream((OutputStream)response.getOutputStream());
            this.writer.write(this.createDocument(request));
            this.writer.flush();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected Document createDocument(HttpServletRequest request) throws ServletException {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("results");
        try {
            String path;
            URL url = this.getDocumentURL(request);
            if (url != null && (path = request.getParameter("path")) != null && path.length() > 0) {
                Document source = this.reader.read(url);
                XPath xpath = source.createXPath(path);
                String contextPath = request.getParameter("contextPath");
                if (contextPath == null) {
                    contextPath = ".";
                }
                List context = source.selectNodes(contextPath);
                List results = null;
                if (!this.getBoolean(request, "sort")) {
                    results = xpath.selectNodes((Object)context);
                } else {
                    String sortPath = request.getParameter("sortPath");
                    if (sortPath == null) {
                        sortPath = ".";
                    }
                    boolean distinct = this.getBoolean(request, "distinct");
                    XPath sortXPath = source.createXPath(sortPath);
                    results = xpath.selectNodes((Object)context, sortXPath, distinct);
                }
                this.appendResults(element, results);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new ServletException("Error parsing document: " + (Object)((Object)e), (Throwable)e);
        }
        return document;
    }

    protected void appendResults(Element element, List results) {
        int size = results.size();
        for (int i = 0; i < size; ++i) {
            Object result = results.get(i);
            if (result instanceof String) {
                element.addText((String)result);
                continue;
            }
            if (result instanceof Node) {
                Node node = (Node)result;
                node.detach();
                element.add(node);
                continue;
            }
            if (result == null) continue;
            element.addText(result.toString());
        }
    }

    protected boolean getBoolean(HttpServletRequest request, String parameterName) {
        String text = request.getParameter(parameterName);
        boolean answer = false;
        if (text != null && text.equalsIgnoreCase("true")) {
            answer = true;
        }
        return answer;
    }

    protected URL getDocumentURL(HttpServletRequest request) throws ServletException {
        String uri = request.getParameter("uri");
        if (uri != null && uri.length() > 0) {
            try {
                return new URL(uri);
            }
            catch (MalformedURLException e) {
                try {
                    return this.getServletContext().getResource(uri);
                }
                catch (MalformedURLException e2) {
                    throw new ServletException("Cannot resolve URI: " + uri, (Throwable)e);
                }
            }
        }
        return null;
    }
}

