/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.xpath;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.taglibs.xtags.xpath.AbstractBodyTag;

public class ElementTag
extends AbstractBodyTag {
    protected static final boolean TRIM_VALUES = true;
    private String name;
    private List attributeNames;
    private Map attributeValues;

    public void addAttribute(String name) {
        if (this.attributeNames == null) {
            this.attributeNames = new ArrayList();
        }
        this.attributeNames.add(name);
    }

    public void setAttributeValue(String name, String value) {
        if (this.attributeValues == null) {
            this.attributeValues = new HashMap();
        }
        this.attributeValues.put(name, value);
    }

    public void release() {
        super.release();
        this.name = null;
        this.attributeNames = null;
        this.attributeValues = null;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doAfterBody() throws JspException {
        JspWriter out = this.bodyContent.getEnclosingWriter();
        try {
            out.print("<" + this.getName());
            this.printAttributes(out);
            String content = this.bodyContent.getString();
            if (content == null || content.length() <= 0) {
                out.print("/>");
            } else {
                out.print(">");
                out.print(content);
                out.print("</" + this.getName() + ">");
            }
            this.bodyContent.clearBody();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void printAttributes(JspWriter out) throws IOException {
        if (this.attributeNames != null) {
            int size = this.attributeNames.size();
            for (int i = 0; i < size; ++i) {
                String attributeName = (String)this.attributeNames.get(i);
                this.printAttribute(out, attributeName);
            }
        }
    }

    protected void printAttribute(JspWriter out, String attributeName) throws IOException {
        Object value = null;
        if (this.attributeValues != null) {
            value = this.attributeValues.get(attributeName);
        }
        String text = attributeName;
        if (value != null) {
            text = value.toString().trim();
        }
        out.print(" " + attributeName + "=\"" + text + "\"");
    }
}

