/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.xpath;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.xtags.util.JspVariableContext;
import org.apache.taglibs.xtags.xpath.AbstractBodyTag;
import org.apache.taglibs.xtags.xpath.ContextNodeTag;
import org.apache.taglibs.xtags.xpath.TagHelper;
import org.dom4j.DocumentFactory;
import org.dom4j.XPath;
import org.jaxen.VariableContext;

public class ForEachTag
extends AbstractBodyTag
implements ContextNodeTag {
    private XPath xpath;
    private String id;
    private String type;
    private Iterator iterator;
    private Object contextNode;
    private XPath sortXPath;
    private boolean distinct;
    private Object context;
    private Object originalContext;
    private boolean ascending = true;

    public void breakLoop() throws JspException {
        this.finishLoop();
    }

    public Object getContext() {
        return this.contextNode;
    }

    public int doStartTag() throws JspException {
        this.originalContext = TagHelper.getInputNodes(this.pageContext);
        this.iterator = null;
        if (this.xpath != null) {
            List list = this.selectNodes();
            this.iterator = list.iterator();
            if (this.hasNext()) {
                return 2;
            }
        }
        this.reset();
        return 0;
    }

    public int doAfterBody() throws JspException {
        if (this.iterator != null) {
            if (this.hasNext()) {
                return 2;
            }
            this.finishLoop();
        }
        TagHelper.setInputNodes(this.pageContext, this.originalContext);
        this.reset();
        return 0;
    }

    public void release() {
        this.reset();
        this.xpath = null;
        this.sortXPath = null;
        this.distinct = false;
        this.ascending = true;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void setSelect(String select) {
        this.xpath = this.createXPath(select);
    }

    public void setSelectXPath(XPath xpath) {
        this.xpath = xpath;
    }

    public void setSort(String sort) {
        this.sortXPath = sort == null ? null : this.createXPath(sort);
    }

    public void setSortXPath(XPath sortXPath) {
        this.sortXPath = sortXPath;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    protected List selectNodes() {
        if (this.xpath != null) {
            Object input = this.getInputNodes();
            if (this.sortXPath != null) {
                List answer = this.xpath.selectNodes(input, this.sortXPath, this.distinct);
                if (!this.ascending) {
                    Collections.reverse(answer);
                }
                return answer;
            }
            return this.xpath.selectNodes(input);
        }
        return Collections.EMPTY_LIST;
    }

    public Object getInputNodes() {
        if (this.context == null) {
            return TagHelper.getInputNodes(this.pageContext, (Tag)this, true);
        }
        return this.context;
    }

    protected void finishLoop() throws JspException {
        this.iterator = null;
        this.contextNode = null;
        try {
            this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
        }
        catch (IOException e) {
            this.handleException(e);
        }
        this.bodyContent.clearBody();
    }

    protected boolean hasNext() {
        if (this.iterator.hasNext()) {
            this.contextNode = this.iterator.next();
            TagHelper.defineVariable(this.pageContext, this.getId(), this.contextNode);
            if (this.contextNode != null) {
                return true;
            }
        }
        return false;
    }

    protected XPath createXPath(String xpathExpression) {
        XPath xpath = this.getDocumentFactory().createXPath(xpathExpression);
        xpath.setVariableContext((VariableContext)JspVariableContext.getInstance(this.pageContext));
        return xpath;
    }

    protected DocumentFactory getDocumentFactory() {
        return DocumentFactory.getInstance();
    }

    private void reset() {
        this.iterator = null;
        this.contextNode = null;
    }
}

