/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.xpath;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.taglibs.xtags.util.URLHelper;
import org.apache.taglibs.xtags.xpath.AbstractBodyTag;
import org.apache.taglibs.xtags.xpath.TagHelper;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ParseTag
extends AbstractBodyTag {
    private static final boolean TRACE = false;
    private String id;
    private URL url;
    private Reader reader;
    private Document document;
    private boolean validate;

    public int doStartTag() throws JspException {
        this.document = null;
        if (this.url != null) {
            try {
                this.document = this.getSAXReader().read(this.url);
                this.defineVariable(this.document);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            return 0;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        if (this.document == null) {
            try {
                if (this.reader != null) {
                    this.document = this.getSAXReader().read(this.reader);
                    this.reader = null;
                } else {
                    BodyContent body = this.getBodyContent();
                    String text = body.getString().trim();
                    body.clearBody();
                    this.document = this.getSAXReader().read((Reader)new StringReader(text));
                }
                this.defineVariable(this.document);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return 0;
    }

    public void release() {
        super.release();
        this.id = null;
        this.url = null;
        this.reader = null;
        this.document = null;
        this.validate = false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public void setUrl(String url) throws IOException {
        this.setURL(new URL(url));
    }

    public void setUri(String uri) throws IOException {
        this.setURL(URLHelper.getResourceURL(uri, this.pageContext));
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    protected SAXReader getSAXReader() throws SAXException {
        try {
            System.setProperty("org.xml.sax.driver", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SAXReader(this.validate);
    }

    protected void defineVariable(Document document) {
        TagHelper.defineVariable(this.pageContext, this.getId(), document);
    }
}

