/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.xpath;

import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.xtags.xpath.AbstractBodyTag;
import org.apache.taglibs.xtags.xpath.TagHelper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ReplaceTag
extends AbstractBodyTag {
    public int doEndTag() throws JspException {
        Object context = TagHelper.getInputNodes(this.pageContext, (Tag)this, false);
        if (context == null) {
            this.logInfo("No current node to replace");
            return 6;
        }
        try {
            String xmlFragment = null;
            if (this.bodyContent != null) {
                xmlFragment = this.bodyContent.getString();
            }
            if (context instanceof List) {
                List els = (List)context;
                if (els.size() > 1) {
                    throw new JspException("Current context contains more than one node");
                }
                if (els.size() == 1) {
                    context = els.get(0);
                }
            }
            if (context instanceof Document) {
                if (xmlFragment == null) {
                    throw new JspException("Cannot replace document with empty body");
                }
                Document sourceDoc = (Document)context;
                Document newDoc = DocumentHelper.parseText((String)xmlFragment);
                sourceDoc.clearContent();
                int size = newDoc.nodeCount();
                for (int i = 0; i < size; ++i) {
                    Node node = newDoc.node(i);
                    node.detach();
                    sourceDoc.add(node);
                }
            } else {
                if (!(context instanceof Element)) {
                    throw new JspException("Current node is not an Element: " + context.getClass().getName());
                }
                Element element = (Element)context;
                SAXReader reader = new SAXReader();
                if (element.isRootElement()) {
                    if (xmlFragment == null) {
                        throw new JspException("Cannot replace root element with empty body");
                    }
                    Document newDoc = DocumentHelper.parseText((String)xmlFragment);
                    Document sourceDoc = element.getDocument();
                    Element newRoot = newDoc.getRootElement();
                    newRoot.detach();
                    sourceDoc.setRootElement(newRoot);
                } else {
                    Element parent = element.getParent();
                    List parentContent = parent.content();
                    int index = parentContent.indexOf(element);
                    parentContent.remove(index);
                    if (xmlFragment != null) {
                        Document newDoc = DocumentHelper.parseText((String)("<dummy>" + xmlFragment + "</dummy>"));
                        parentContent.addAll(index, newDoc.getRootElement().content());
                    }
                }
            }
        }
        catch (DocumentException e) {
            this.handleException((Exception)((Object)e));
        }
        return 6;
    }

    public void release() {
        super.release();
    }
}

