/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.xpath;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.xtags.util.JspVariableContext;
import org.apache.taglibs.xtags.xpath.AbstractBodyTag;
import org.apache.taglibs.xtags.xpath.StylesheetValueOfAction;
import org.apache.taglibs.xtags.xpath.TagHelper;
import org.apache.taglibs.xtags.xpath.TemplateExecution;
import org.dom4j.DocumentFactory;
import org.dom4j.InvalidXPathException;
import org.dom4j.XPath;
import org.dom4j.rule.Action;
import org.dom4j.rule.Rule;
import org.dom4j.rule.Stylesheet;
import org.jaxen.VariableContext;

public class StylesheetTag
extends AbstractBodyTag {
    private Stylesheet stylesheet = new Stylesheet();
    private String mode;
    private Stylesheet previousStylesheet;
    private Action valueOfAction;
    private Stack templateResultLists = new Stack();
    private Stack resultIterators = new Stack();
    private List openResultList;
    private int currentState;
    private TemplateExecution currentMatch;
    private StringBuffer avtOutput = new StringBuffer(256);
    private StringBuffer actionOutput = new StringBuffer(2048);
    static final int INITIALISE_STYLESHEET = 1;
    static final int RUN_TEMPLATES = 2;
    protected Object context;

    public StylesheetTag() {
        this.valueOfAction = new StylesheetValueOfAction(this);
        this.stylesheet.setValueOfAction(this.valueOfAction);
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void addTemplate(Rule rule) {
        this.stylesheet.addRule(rule);
    }

    int getCurrentState() {
        return this.currentState;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
    }

    public int doStartTag() throws JspException {
        this.previousStylesheet = TagHelper.getStylesheet(this.pageContext);
        TagHelper.setStylesheet(this.pageContext, this.stylesheet);
        this.stylesheet.clear();
        this.templateResultLists.clear();
        this.actionOutput.delete(0, this.actionOutput.length());
        this.currentState = 1;
        return 2;
    }

    public int doAfterBody() throws JspException {
        try {
            if (this.currentState == 1) {
                this.runStylesheet();
                this.currentState = 2;
            } else {
                this.addOutputToResultList();
                this.bodyContent.clear();
            }
            if (this.openResultList != null) {
                this.templateResultLists.push(this.openResultList);
                this.resultIterators.push(this.openResultList.iterator());
                this.openResultList = null;
            }
            return this.processResults();
        }
        catch (Exception e) {
            this.handleException(e);
            return 0;
        }
    }

    public int doEndTag() throws JspException {
        TagHelper.setStylesheet(this.pageContext, this.previousStylesheet);
        this.reset();
        return 6;
    }

    public void runStylesheet() throws Exception {
        this.stylesheet.setModeName(this.getMode());
        this.stylesheet.run(this.getInputNodes());
    }

    int processResults() throws IOException {
        while (!this.resultIterators.isEmpty()) {
            Iterator resultIter = (Iterator)this.resultIterators.peek();
            while (resultIter.hasNext()) {
                Object o = resultIter.next();
                if (o instanceof String) {
                    this.bodyContent.getEnclosingWriter().write((String)o);
                    continue;
                }
                this.currentMatch = (TemplateExecution)o;
                return 2;
            }
            this.resultIterators.pop();
            this.templateResultLists.pop();
        }
        return 0;
    }

    TemplateExecution getTemplateExecution(String match) {
        if (this.currentMatch.getMatch().equals(match)) {
            return this.currentMatch;
        }
        return null;
    }

    public void release() {
        super.release();
        this.reset();
    }

    void reset() {
        this.stylesheet.clear();
        this.openResultList = null;
        this.currentMatch = null;
        this.templateResultLists.clear();
        this.resultIterators.clear();
        this.actionOutput.delete(0, this.actionOutput.length());
        this.avtOutput.delete(0, this.actionOutput.length());
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    void addOutput(String text) {
        this.actionOutput.append(text);
    }

    void addOutputToResultList() {
        if (this.actionOutput.length() > 0) {
            this.getOpenResultList().add(this.actionOutput.toString());
            this.actionOutput.delete(0, this.actionOutput.length());
        }
    }

    void addTemplateExecution(TemplateExecution te) {
        this.addOutputToResultList();
        this.getOpenResultList().add(te);
    }

    List getOpenResultList() {
        if (this.openResultList == null) {
            this.openResultList = new ArrayList(256);
        }
        return this.openResultList;
    }

    String processAVTs(String text) throws IOException, InvalidXPathException {
        int leftBracket;
        int marker = 0;
        Object context = this.getInputNodes();
        this.avtOutput.delete(0, this.avtOutput.length());
        while ((leftBracket = text.indexOf(123, marker)) > 0) {
            this.avtOutput.append(text.substring(marker, leftBracket));
            int rightBracket = text.indexOf(125, leftBracket);
            if (rightBracket < 0) {
                marker = leftBracket;
                break;
            }
            XPath xpath = this.createXPath(text.substring(leftBracket + 1, rightBracket));
            if (xpath == null) {
                throw new InvalidXPathException(text.substring(leftBracket + 1, rightBracket));
            }
            this.avtOutput.append(xpath.valueOf(context));
            marker = rightBracket + 1;
        }
        if (marker < text.length()) {
            this.avtOutput.append(text.substring(marker));
        }
        return this.avtOutput.toString();
    }

    public Object getInputNodes() {
        if (this.context == null) {
            return TagHelper.getInputNodes(this.pageContext, (Tag)this, true);
        }
        return this.context;
    }

    protected XPath createXPath(String xpathExpression) {
        XPath xpath = this.getDocumentFactory().createXPath(xpathExpression);
        xpath.setVariableContext((VariableContext)JspVariableContext.getInstance(this.pageContext));
        return xpath;
    }

    protected DocumentFactory getDocumentFactory() {
        return DocumentFactory.getInstance();
    }

    public void setContext(Object context) {
        this.context = context;
    }
}

