/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.xpath;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.xtags.xpath.AbstractTag;
import org.dom4j.XPath;

public class ValueOfTag
extends AbstractTag {
    private XPath xpath;

    public int doStartTag() throws JspException {
        if (this.xpath != null) {
            try {
                String text = this.xpath.valueOf(this.getInputNodes());
                text = ValueOfTag.encode(text);
                this.pageContext.getOut().print(text);
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
        return 0;
    }

    public void release() {
        super.release();
        this.xpath = null;
    }

    public void setSelect(String select) {
        this.xpath = this.createXPath(select);
    }

    public void setSelectXPath(XPath xpath) {
        this.xpath = xpath;
    }

    public static String encode(String text) {
        StringBuffer buffer = new StringBuffer();
        char[] block = text.toCharArray();
        int size = block.length;
        int last = 0;
        for (int i = 0; i < size; ++i) {
            char ch = block[i];
            String entity = null;
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
            }
            if (entity == null) continue;
            buffer.append(block, last, i - last);
            buffer.append(entity);
            last = i + 1;
        }
        if (last < size) {
            buffer.append(block, last, size - last);
        }
        return buffer.toString();
    }
}

