/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.xtags.xslt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.taglibs.xtags.util.JspNestedException;
import org.apache.taglibs.xtags.util.URLHelper;
import org.apache.taglibs.xtags.xslt.ParameterAcceptingTag;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class StyleTag
extends BodyTagSupport
implements ParameterAcceptingTag {
    private Object xml;
    private Object xsl;
    private Result result;
    private String outputMethod;
    private Map parameters;
    private StringWriter stringWriter;

    public void setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public int doStartTag() throws JspException {
        this.parameters = null;
        return 2;
    }

    public int doAfterBody() throws JspException {
        String text;
        if (this.bodyContent != null && (text = this.bodyContent.getString().trim()).length() > 0) {
            if (this.xsl == null) {
                this.xsl = new StringReader(text);
            } else if (this.xml == null) {
                this.xml = new StringReader(text);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        if (this.xml == null || this.xsl == null) {
            throw new JspException("Must specify both XML and an XSLT to style");
        }
        Source data = this.getSource(this.xml);
        Source style = this.getSource(this.xsl);
        Result result = this.getResult();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(this.createURIResolver());
            Transformer transformer = factory.newTransformer(style);
            this.configure(transformer);
            transformer.transform(data, result);
            if (this.stringWriter != null) {
                this.pageContext.getOut().write(this.stringWriter.toString());
            }
        }
        catch (TransformerException e) {
            this.handleException(e);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        finally {
            this.stringWriter = null;
        }
        return 6;
    }

    public void release() {
        this.xml = null;
        this.xsl = null;
        this.result = null;
        this.parameters = null;
    }

    public void setOutputMethod(String outputMethod) {
        this.outputMethod = outputMethod;
    }

    public void setDocument(Document document) {
        this.xml = document;
    }

    public void setTransformer(Transformer transformer) {
        this.xsl = transformer;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setWriter(Writer writer) {
        this.setResult(new StreamResult(writer));
    }

    public void setResultHandler(ContentHandler handler) {
        this.setResult(new SAXResult(handler));
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public void setXmlSource(Source source) {
        this.xml = source;
    }

    public void setXmlReader(Reader reader) {
        this.xml = reader;
    }

    public void setXsl(String xsl) {
        this.xsl = xsl;
    }

    public void setXslReader(Reader reader) {
        this.xsl = reader;
    }

    public void setXslSource(Source source) {
        this.xsl = source;
    }

    protected void configure(Transformer transformer) {
        if (this.outputMethod != null) {
            transformer.setOutputProperty("method", this.outputMethod);
        }
        if (this.parameters != null) {
            Iterator iter = this.parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                transformer.setParameter(name, value);
            }
        }
    }

    protected Source getSource(Object source) throws JspException {
        if (source instanceof Source) {
            return (Source)source;
        }
        if (source instanceof Reader) {
            return new StreamSource((Reader)source);
        }
        if (source instanceof String) {
            try {
                URL url = URLHelper.createURL((String)source, this.pageContext);
                if (url == null) {
                    throw new JspException("Bad URL: " + source + ".");
                }
                return new StreamSource(url.openStream(), url.toExternalForm());
            }
            catch (IOException e) {
                throw new JspException("Bad URL: " + source + ". Exception: " + e.getMessage());
            }
        }
        if (source instanceof Node) {
            return new DocumentSource((Node)source);
        }
        if (source instanceof org.w3c.dom.Node) {
            return new DOMSource((org.w3c.dom.Node)source);
        }
        if (source instanceof InputSource) {
            return new SAXSource((InputSource)source);
        }
        if (source == null) {
            throw new JspException("No XSLT source specified");
        }
        throw new JspException("Invalid input source type '" + source.getClass().getName() + "'");
    }

    protected Result getResult() throws JspException {
        if (this.result == null) {
            this.stringWriter = new StringWriter();
            return new StreamResult(this.stringWriter);
        }
        this.stringWriter = null;
        return this.result;
    }

    protected URIResolver createURIResolver() {
        return new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                try {
                    return StyleTag.this.getSource(href);
                }
                catch (JspException e) {
                    return null;
                }
            }
        };
    }

    protected void handleException(Exception e) throws JspException {
        if (e instanceof JspException) {
            throw (JspException)((Object)e);
        }
        this.pageContext.getServletContext().log(e.getMessage(), (Throwable)e);
        e.printStackTrace();
        throw new JspNestedException(e);
    }
}

