/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.UnsupportedEncodingException;

class Buffer {
    public byte[] _buf;
    int _bufLength = 0;
    public int _pos = 0;
    int _sendLength = 0;
    static final int NO_LENGTH_LIMIT = -1;
    int _maxLength = -1;
    static long NULL_LENGTH = -1L;

    Buffer(byte[] byArray) {
        this._buf = byArray;
        this._bufLength = byArray.length;
    }

    Buffer(int n, int n2) {
        this._buf = new byte[n];
        this._bufLength = this._buf.length;
        this._pos = 4;
        this._maxLength = n2;
    }

    Buffer(int n) {
        this(n, -1);
    }

    final void setBytes(byte[] byArray) {
        this._sendLength = this._bufLength;
        System.arraycopy(byArray, 0, this._buf, 0, this._bufLength);
    }

    final byte readByte() {
        return this._buf[this._pos++];
    }

    final int readInt() {
        byte[] byArray = this._buf;
        return byArray[this._pos++] & 0xFF | (byArray[this._pos++] & 0xFF) << 8;
    }

    final int readLongInt() {
        byte[] byArray = this._buf;
        return byArray[this._pos++] & 0xFF | (byArray[this._pos++] & 0xFF) << 8 | (byArray[this._pos++] & 0xFF) << 16;
    }

    final long readLong() {
        byte[] byArray = this._buf;
        return byArray[this._pos++] & 0xFF | (byArray[this._pos++] & 0xFF) << 8 | (byArray[this._pos++] & 0xFF) << 16 | (byArray[this._pos++] & 0xFF) << 24;
    }

    final long readLongLong() {
        byte[] byArray = this._buf;
        return (long)(byArray[this._pos++] & 0xFF) | (long)(byArray[this._pos++] & 0xFF) << 8 | (long)(byArray[this._pos++] & 0xFF) << 16 | (long)(byArray[this._pos++] & 0xFF) << 24 | (long)(byArray[this._pos++] & 0xFF) << 32 | (long)(byArray[this._pos++] & 0xFF) << 40 | (long)(byArray[this._pos++] & 0xFF) << 48 | (long)(byArray[this._pos++] & 0xFF) << 56;
    }

    final int readnBytes() {
        int n = this._buf[this._pos++] & 0xFF;
        switch (n) {
            case 1: {
                return this._buf[this._pos++] & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final long readLength() {
        int n = this._buf[this._pos++] & 0xFF;
        switch (n) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return n;
    }

    final long newReadLength() {
        int n = this._buf[this._pos++] & 0xFF;
        switch (n) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return n;
    }

    final long readFieldLength() {
        int n = this._buf[this._pos++] & 0xFF;
        switch (n) {
            case 251: {
                return NULL_LENGTH;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return n;
    }

    final byte[] readByteArray() {
        return this.getNullTerminatedBytes();
    }

    final byte[] readLenByteArray() {
        long l = this.readFieldLength();
        if (l == NULL_LENGTH) {
            return null;
        }
        if (l == 0L) {
            return new byte[0];
        }
        return this.getBytes((int)l);
    }

    final String readString() {
        int n = this._pos;
        int n2 = 0;
        while (this._buf[n] != 0 && n < this._bufLength) {
            ++n2;
            ++n;
        }
        String string = new String(this._buf, this._pos, n2);
        this._pos += n2 + 1;
        return string;
    }

    final String readLenString() {
        long l = this.readFieldLength();
        if (l == NULL_LENGTH) {
            return null;
        }
        if (l == 0L) {
            return "";
        }
        String string = new String(this._buf, this._pos, (int)l);
        this._pos = (int)((long)this._pos + l);
        return string;
    }

    final byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this._buf, this._pos, byArray, 0, n);
        this._pos += n;
        return byArray;
    }

    final byte[] getNullTerminatedBytes() {
        int n = this._pos;
        int n2 = 0;
        while (this._buf[n] != 0 && n < this._bufLength) {
            ++n2;
            ++n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this._buf, this._pos, byArray, 0, n2);
        this._pos += n2 + 1;
        return byArray;
    }

    final boolean isLastDataPacket() {
        return this._bufLength <= 2 && (this._buf[0] & 0xFF) == 254;
    }

    final void clear() {
        this._pos = 4;
    }

    final void writeByte(byte by) {
        this._buf[this._pos++] = by;
    }

    final void writeInt(int n) {
        byte[] byArray = this._buf;
        byArray[this._pos++] = (byte)(n & 0xFF);
        byArray[this._pos++] = (byte)(n >>> 8);
    }

    final void writeLongInt(int n) {
        byte[] byArray = this._buf;
        byArray[this._pos++] = (byte)(n & 0xFF);
        byArray[this._pos++] = (byte)(n >>> 8);
        byArray[this._pos++] = (byte)(n >>> 16);
    }

    final void writeLong(long l) {
        byte[] byArray = this._buf;
        byArray[this._pos++] = (byte)(l & 0xFFL);
        byArray[this._pos++] = (byte)(l >>> 8);
        byArray[this._pos++] = (byte)(l >>> 16);
        byArray[this._pos++] = (byte)(l >>> 24);
    }

    final void writeString(String string) {
        this.writeStringNoNull(string);
        this._buf[this._pos++] = 0;
    }

    final void writeStringNoNull(String string) {
        int n = string.length();
        this.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            this._buf[this._pos++] = (byte)string.charAt(n2);
            ++n2;
        }
    }

    final void writeStringNoNull(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this._buf, this._pos, n);
        this._pos += n;
    }

    final void writeBytesNoNull(byte[] byArray) {
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this._buf, this._pos, n);
        this._pos += n;
    }

    final void ensureCapacity(int n) {
        if (this._pos + n > this._bufLength) {
            int n2 = (int)((double)this._bufLength * 1.25);
            if (n2 < this._bufLength + n) {
                n2 = this._bufLength + (int)((double)n * 1.25);
            }
            if (this._maxLength != -1 && n2 > this._maxLength) {
                throw new IllegalArgumentException("Packet is larger than max_allowed_packet from server configuration of " + this._maxLength + " bytes");
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this._buf, 0, byArray, 0, this._buf.length);
            this._buf = byArray;
            this._bufLength = this._buf.length;
        }
    }

    final void dump() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this._bufLength / 8;
        int n5 = 0;
        while (n5 < n4) {
            n2 = n3;
            n = 0;
            while (n < 8) {
                String string = Integer.toHexString(this._buf[n2]);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
                ++n2;
                ++n;
            }
            System.out.print("    ");
            int n6 = 0;
            while (n6 < 8) {
                if (this._buf[n3] > 32 && this._buf[n3] < 127) {
                    System.out.print((char)this._buf[n3] + " ");
                } else {
                    System.out.print(". ");
                }
                ++n3;
                ++n6;
            }
            System.out.println();
            ++n5;
        }
        n2 = 0;
        n = n3;
        while (n < this._bufLength) {
            String string = Integer.toHexString(this._buf[n]);
            if (string.length() == 1) {
                string = "0" + string;
            }
            System.out.print(string + " ");
            ++n2;
            ++n;
        }
        int n7 = n2;
        while (n7 < 8) {
            System.out.print("   ");
            ++n7;
        }
        System.out.print("    ");
        int n8 = n3;
        while (n8 < this._bufLength) {
            if (this._buf[n8] > 32 && this._buf[n8] < 127) {
                System.out.print((char)this._buf[n8] + " ");
            } else {
                System.out.print(". ");
            }
            ++n8;
        }
        System.out.println();
    }
}

