/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;

public class CSV {
    public CSV(Workbook w, OutputStream out, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            for (int sheet = 0; sheet < w.getNumberOfSheets(); ++sheet) {
                Sheet s = w.getSheet(sheet);
                bw.write(s.getName());
                bw.newLine();
                Cell[] row = null;
                for (int i = 0; i < s.getRows(); ++i) {
                    int j;
                    row = s.getRow(i);
                    int nonblank = 0;
                    for (j = row.length - 1; j >= 0; --j) {
                        if (row[j].getType() == CellType.EMPTY) continue;
                        nonblank = j;
                        break;
                    }
                    bw.write(row[0].getContents());
                    for (j = 1; j <= nonblank; ++j) {
                        bw.write(44);
                        bw.write(row[j].getContents());
                    }
                    bw.newLine();
                }
            }
            bw.flush();
            bw.close();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
        }
    }
}

