/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.io.File;
import jxl.CSV;
import jxl.Cell;
import jxl.Range;
import jxl.ReadWrite;
import jxl.Workbook;
import jxl.Write;
import jxl.XML;

public class Demo {
    private static final int CSVFormat = 13;
    private static final int XMLFormat = 14;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Command format:  Demo [-unicode] [-xml|-csv] excelfile");
            System.err.println("                 Demo -write excelfile");
            System.err.println("                 Demo -readwrite|-rw excelfile output");
            System.err.println("                 Demo -version");
            System.exit(1);
        }
        if (args[0].equals("-version")) {
            System.out.println("v".concat(String.valueOf(String.valueOf(Workbook.getVersion()))));
            System.exit(0);
        }
        boolean write = false;
        boolean readwrite = false;
        String file = args[0];
        String outputFile = null;
        if (args[0].equals("-write")) {
            write = true;
            file = args[1];
        } else if (args[0].equals("-readwrite") || args[0].equals("-rw")) {
            readwrite = true;
            file = args[1];
            outputFile = args[2];
        } else {
            file = args[args.length - 1];
        }
        String encoding = "UTF8";
        int format = 13;
        if (!write && !readwrite) {
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i].equals("-unicode")) {
                    encoding = "UnicodeBig";
                    continue;
                }
                if (args[i].equals("-xml")) {
                    format = 14;
                    continue;
                }
                if (args[i].equals("-csv")) {
                    format = 13;
                    continue;
                }
                System.err.println("Command format:  CSV [-unicode] [-xml|-csv] excelfile");
                System.exit(1);
            }
        }
        try {
            if (write) {
                Write w = new Write(file);
                w.write();
            } else if (readwrite) {
                ReadWrite rw = new ReadWrite(file, outputFile);
                rw.readWrite();
            } else {
                Workbook w = Workbook.getWorkbook(new File(file));
                if (format == 13) {
                    CSV cSV = new CSV(w, System.out, encoding);
                } else if (format == 14) {
                    XML xML = new XML(w, System.out, encoding);
                }
                w.close();
            }
        }
        catch (Throwable t) {
            System.out.println(t.toString());
            t.printStackTrace();
        }
    }

    private static void findTest(Workbook w) {
        int i;
        Range[] range;
        System.out.println("Find test");
        Cell c = w.findCellByName("named1");
        if (c != null) {
            System.out.println("named1 contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
        }
        if ((c = w.findCellByName("named2")) != null) {
            System.out.println("named2 contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
        }
        if ((c = w.findCellByName("namedrange")) != null) {
            System.out.println("named2 contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
        }
        if ((range = w.findByName("namedrange")) != null) {
            c = range[0].getTopLeft();
            System.out.println("namedrange top left contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
            c = range[0].getBottomRight();
            System.out.println("namedrange bottom right contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
        }
        if ((range = w.findByName("nonadjacentrange")) != null) {
            for (i = 0; i < range.length; ++i) {
                c = range[i].getTopLeft();
                System.out.println("nonadjacent top left contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
                c = range[i].getBottomRight();
                System.out.println("nonadjacent bottom right contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
            }
        }
        if ((range = w.findByName("horizontalnonadjacentrange")) != null) {
            for (i = 0; i < range.length; ++i) {
                c = range[i].getTopLeft();
                System.out.println("horizontalnonadjacent top left contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
                c = range[i].getBottomRight();
                System.out.println("horizontalnonadjacent bottom right contents:  ".concat(String.valueOf(String.valueOf(c.getContents()))));
            }
        }
    }

    static {
        CSVFormat = 13;
        XMLFormat = 14;
    }
}

