/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.read.biff.BiffException;
import jxl.read.biff.File;
import jxl.read.biff.PasswordException;
import jxl.read.biff.WorkbookParser;
import jxl.write.WritableWorkbook;
import jxl.write.biff.WritableWorkbookImpl;

public abstract class Workbook {
    private static final String version = "2.0.5";

    protected Workbook() {
    }

    public abstract Sheet[] getSheets();

    public abstract Sheet getSheet(int var1) throws IndexOutOfBoundsException;

    public abstract Sheet getSheet(String var1);

    public static String getVersion() {
        return version;
    }

    public abstract int getNumberOfSheets();

    public abstract Cell findCellByName(String var1);

    public abstract Range[] findByName(String var1);

    protected abstract void parse() throws PasswordException, BiffException;

    public abstract void close();

    public static Workbook getWorkbook(java.io.File file) throws BiffException, IOException {
        FileInputStream fis = new FileInputStream(file);
        File dataFile = new File(fis);
        fis.close();
        WorkbookParser workbook = new WorkbookParser(dataFile);
        ((Workbook)workbook).parse();
        return workbook;
    }

    public static Workbook getWorkbook(InputStream is) throws BiffException, IOException {
        File dataFile = new File(is);
        WorkbookParser workbook = new WorkbookParser(dataFile);
        ((Workbook)workbook).parse();
        return workbook;
    }

    public static WritableWorkbook createWorkbook(java.io.File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        WritableWorkbookImpl w = new WritableWorkbookImpl(fos);
        return w;
    }

    public static WritableWorkbook createWorkbook(java.io.File file, Workbook in) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        WritableWorkbookImpl w = new WritableWorkbookImpl(fos, in);
        return w;
    }

    public static WritableWorkbook createWorkbook(OutputStream os, Workbook in) throws IOException {
        WritableWorkbookImpl w = new WritableWorkbookImpl(os, in);
        return w;
    }

    public static WritableWorkbook createWorkbook(OutputStream os) throws IOException {
        WritableWorkbookImpl w = new WritableWorkbookImpl(os);
        return w;
    }

    static {
        version = version;
    }
}

