/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;

public class XML {
    public XML(Workbook w, OutputStream out, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write("<?xml version=\"1.0\" ?>");
            bw.newLine();
            bw.write("<!DOCTYPE workbook SYSTEM \"workbook.dtd\">");
            bw.newLine();
            bw.newLine();
            bw.write("<workbook>");
            bw.newLine();
            for (int sheet = 0; sheet < w.getNumberOfSheets(); ++sheet) {
                Sheet s = w.getSheet(sheet);
                bw.write("  <sheet>");
                bw.newLine();
                bw.write(String.valueOf(String.valueOf(new StringBuffer("    <name><![CDATA[").append(s.getName()).append("]]></name>"))));
                bw.newLine();
                Cell[] row = null;
                for (int i = 0; i < s.getRows(); ++i) {
                    bw.write(String.valueOf(String.valueOf(new StringBuffer("    <row number=\"").append(i).append("\">"))));
                    bw.newLine();
                    row = s.getRow(i);
                    boolean nonblank = false;
                    for (int j = 0; j < row.length; ++j) {
                        if (row[j].getType() == CellType.EMPTY) continue;
                        bw.write(String.valueOf(String.valueOf(new StringBuffer("      <col number=\"").append(j).append("\">"))));
                        bw.write(String.valueOf(String.valueOf(new StringBuffer("<![CDATA[").append(row[j].getContents()).append("]]>"))));
                        bw.write("</col>");
                        bw.newLine();
                    }
                    bw.write("    </row>");
                    bw.newLine();
                }
                bw.write("  </sheet>");
                bw.newLine();
            }
            bw.write("</workbook>");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
        }
    }
}

