/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import jxl.biff.IntegerHelper;

public abstract class BaseCompoundFile {
    protected static byte[] identifier = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    protected static int NUM_BIG_BLOCK_DEPOT_BLOCKS_POS = 44;
    protected static int SMALL_BLOCK_DEPOT_BLOCK_POS = 60;
    protected static int ROOT_START_BLOCK_POS = 48;
    protected static int BIG_BLOCK_SIZE = 512;
    protected static int SMALL_BLOCK_SIZE = 64;
    protected static int EXTENSION_BLOCK_POS = 68;
    protected static int NUM_EXTENSION_BLOCK_POS = 72;
    protected static int PROPERTY_STORAGE_BLOCK_SIZE = 128;
    protected static int BIG_BLOCK_DEPOT_BLOCKS_POS = 76;
    protected static int SMALL_BLOCK_THRESHOLD = 4096;
    private static int SIZE_OF_NAME_POS = 64;
    private static int TYPE_POS = 66;
    private static int PREVIOUS_POS = 68;
    private static int NEXT_POS = 72;
    private static int DIRECTORY_POS = 76;
    private static int START_BLOCK_POS = 116;
    private static int SIZE_POS = 120;

    protected BaseCompoundFile() {
    }

    protected class PropertyStorage {
        public String name;
        public int type;
        public int startBlock;
        public int size;
        public int previous;
        public int next;
        public int directory;
        public byte[] data;

        public PropertyStorage(BaseCompoundFile this$0, byte[] d) {
            this.data = d;
            int nameSize = IntegerHelper.getInt(this.data[SIZE_OF_NAME_POS], this.data[SIZE_OF_NAME_POS + 1]);
            this.type = this.data[TYPE_POS];
            this.startBlock = IntegerHelper.getInt(this.data[START_BLOCK_POS], this.data[START_BLOCK_POS + 1], this.data[START_BLOCK_POS + 2], this.data[START_BLOCK_POS + 3]);
            this.size = IntegerHelper.getInt(this.data[SIZE_POS], this.data[SIZE_POS + 1], this.data[SIZE_POS + 2], this.data[SIZE_POS + 3]);
            int chars = 0;
            if (nameSize > 2) {
                chars = (nameSize - 1) / 2;
            }
            StringBuffer n = new StringBuffer("");
            for (int i = 0; i < chars; ++i) {
                n.append((char)this.data[i * 2]);
            }
            this.name = n.toString();
        }

        public PropertyStorage(BaseCompoundFile this$0, String name) {
            this.data = new byte[PROPERTY_STORAGE_BLOCK_SIZE];
            Assert.verify(name.length() < 32);
            IntegerHelper.getTwoBytes((name.length() + 1) * 2, this.data, SIZE_OF_NAME_POS);
            for (int i = 0; i < name.length(); ++i) {
                this.data[i * 2] = (byte)name.charAt(i);
            }
        }

        public void setType(int t) {
            this.type = t;
            this.data[TYPE_POS] = (byte)t;
            this.data[TYPE_POS + 1] = 1;
        }

        public void setStartBlock(int sb) {
            this.startBlock = sb;
            IntegerHelper.getFourBytes(sb, this.data, START_BLOCK_POS);
        }

        public void setSize(int s) {
            this.size = s;
            IntegerHelper.getFourBytes(s, this.data, SIZE_POS);
        }

        public void setPrevious(int prev) {
            this.previous = prev;
            IntegerHelper.getFourBytes(prev, this.data, PREVIOUS_POS);
        }

        public void setNext(int nxt) {
            this.next = nxt;
            IntegerHelper.getFourBytes(this.next, this.data, NEXT_POS);
        }

        public void setDirectory(int dir) {
            this.directory = dir;
            IntegerHelper.getFourBytes(this.directory, this.data, DIRECTORY_POS);
        }
    }
}

