/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;

public class FontRecord
extends WritableRecordData {
    private int pointHeight;
    private int colourIndex;
    private int boldWeight;
    private int scriptStyle;
    private int underlineStyle;
    private boolean italic;
    private String name;
    private boolean initialized;
    private int fontIndex;
    public static Biff7 biff7 = new Biff7();

    protected FontRecord(String fn, int ps, int bold, boolean it, int us, int ci, int ss) {
        super(Type.FONT);
        this.boldWeight = bold;
        this.underlineStyle = us;
        this.name = fn;
        this.pointHeight = ps;
        this.italic = it;
        this.scriptStyle = ss;
        this.colourIndex = ci;
        this.initialized = false;
    }

    public FontRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.pointHeight = IntegerHelper.getInt(data[0], data[1]) / 20;
        this.colourIndex = IntegerHelper.getInt(data[4], data[5]);
        this.boldWeight = IntegerHelper.getInt(data[6], data[7]);
        this.scriptStyle = IntegerHelper.getInt(data[8], data[9]);
        this.underlineStyle = data[10];
        this.initialized = false;
        if ((data[2] & 2) != 0) {
            this.italic = true;
        }
        byte numChars = data[14];
        if (data[15] == 0) {
            this.name = StringHelper.getString(data, numChars, 16);
        } else if (data[15] == 1) {
            this.name = StringHelper.getUnicodeString(data, numChars, 16);
        } else {
            System.out.println("Read non unicode font ".concat(String.valueOf(String.valueOf(this.name))));
        }
    }

    public FontRecord(Record t, Biff7 dummy) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.pointHeight = IntegerHelper.getInt(data[0], data[1]) / 20;
        this.colourIndex = IntegerHelper.getInt(data[4], data[5]);
        this.boldWeight = IntegerHelper.getInt(data[6], data[7]);
        this.scriptStyle = IntegerHelper.getInt(data[8], data[9]);
        this.underlineStyle = data[10];
        this.initialized = false;
        if ((data[2] & 2) != 0) {
            this.italic = true;
        }
        byte numChars = data[14];
        this.name = StringHelper.getString(data, numChars, 15);
    }

    public byte[] getData() {
        byte[] data = new byte[16 + this.name.length() * 2];
        IntegerHelper.getTwoBytes(this.pointHeight * 20, data, 0);
        if (this.italic) {
            data[2] = (byte)(data[2] | 2);
        }
        IntegerHelper.getTwoBytes(this.colourIndex, data, 4);
        IntegerHelper.getTwoBytes(this.boldWeight, data, 6);
        IntegerHelper.getTwoBytes(this.scriptStyle, data, 8);
        data[10] = (byte)this.underlineStyle;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = (byte)this.name.length();
        data[15] = 1;
        StringHelper.getUnicodeBytes(this.name, data, 16);
        return data;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final void initialize(int pos) {
        this.fontIndex = pos;
        this.initialized = true;
    }

    public final void uninitialize() {
        this.initialized = false;
    }

    public final int getFontIndex() {
        return this.fontIndex;
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

