/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.biff.BuiltInStyle;
import jxl.biff.Fonts;
import jxl.biff.Format;
import jxl.biff.FormatRecord;
import jxl.biff.XFRecord;
import jxl.write.biff.File;

public class FormattingRecords {
    private HashMap formats;
    private ArrayList formatsList;
    private ArrayList xfRecords = new ArrayList(10);
    private int nextCustomIndexNumber;
    private Fonts fonts;
    private static final int customFormatStartIndex = 164;

    public FormattingRecords(Fonts f) {
        this.formats = new HashMap(10);
        this.formatsList = new ArrayList(10);
        this.fonts = f;
        this.nextCustomIndexNumber = 164;
    }

    public final void addStyle(XFRecord xf) {
        if (!xf.isInitialized()) {
            int pos = this.xfRecords.size();
            xf.initialize(pos, this, this.fonts);
            this.xfRecords.add(xf);
        } else if (xf.getXFIndex() >= this.xfRecords.size()) {
            this.xfRecords.add(xf);
        }
    }

    public final void addFormat(Format fr) {
        if (!fr.isInitialized()) {
            fr.initialize(this.nextCustomIndexNumber);
            ++this.nextCustomIndexNumber;
        }
        if (fr.getFormatIndex() >= this.nextCustomIndexNumber) {
            this.nextCustomIndexNumber = fr.getFormatIndex() + 1;
        }
        if (!fr.isBuiltIn()) {
            this.formatsList.add(fr);
            this.formats.put(new Integer(fr.getFormatIndex()), fr);
        }
    }

    public final boolean isDate(int pos) {
        XFRecord xfr = (XFRecord)this.xfRecords.get(pos);
        if (xfr.isDate()) {
            return true;
        }
        FormatRecord fr = (FormatRecord)this.formats.get(new Integer(xfr.getFormatRecord()));
        return fr == null ? false : fr.isDate();
    }

    public final DateFormat getDateFormat(int pos) {
        XFRecord xfr = (XFRecord)this.xfRecords.get(pos);
        if (xfr.isDate()) {
            return xfr.getDateFormat();
        }
        FormatRecord fr = (FormatRecord)this.formats.get(new Integer(xfr.getFormatRecord()));
        if (fr == null) {
            return null;
        }
        return fr.isDate() ? fr.getDateFormat() : null;
    }

    public final NumberFormat getNumberFormat(int pos) {
        XFRecord xfr = (XFRecord)this.xfRecords.get(pos);
        if (xfr.isNumber()) {
            return xfr.getNumberFormat();
        }
        FormatRecord fr = (FormatRecord)this.formats.get(new Integer(xfr.getFormatRecord()));
        if (fr == null) {
            return null;
        }
        return fr.isNumber() ? fr.getNumberFormat() : null;
    }

    public void write(File outputFile) throws IOException {
        Iterator i = ((AbstractList)this.formatsList).iterator();
        FormatRecord fr = null;
        while (i.hasNext()) {
            fr = (FormatRecord)i.next();
            outputFile.write(fr);
        }
        i = ((AbstractList)this.xfRecords).iterator();
        XFRecord xfr = null;
        while (i.hasNext()) {
            xfr = (XFRecord)i.next();
            outputFile.write(xfr);
        }
        BuiltInStyle style = new BuiltInStyle(16, 3);
        outputFile.write(style);
        style = new BuiltInStyle(17, 6);
        outputFile.write(style);
        style = new BuiltInStyle(18, 4);
        outputFile.write(style);
        style = new BuiltInStyle(19, 7);
        outputFile.write(style);
        style = new BuiltInStyle(0, 0);
        outputFile.write(style);
        style = new BuiltInStyle(20, 5);
        outputFile.write(style);
    }

    protected final Fonts getFonts() {
        return this.fonts;
    }

    public final XFRecord getXFRecord(int index) {
        return (XFRecord)this.xfRecords.get(index);
    }

    static {
        customFormatStartIndex = 164;
    }
}

