/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import jxl.CellFormat;
import jxl.biff.FontRecord;
import jxl.biff.Fonts;
import jxl.biff.Format;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;
import jxl.write.Alignment;
import jxl.write.Border;
import jxl.write.BorderLineStyle;
import jxl.write.Colour;
import jxl.write.Pattern;
import jxl.write.VerticalAlignment;

public class XFRecord
extends WritableRecordData
implements CellFormat {
    private int formatIndex;
    private boolean date;
    private boolean number;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private int fontIndex;
    private boolean locked;
    private boolean hidden;
    private Alignment align;
    private VerticalAlignment valign;
    private int orientation;
    private boolean wrap;
    private BorderLineStyle leftBorder;
    private BorderLineStyle rightBorder;
    private BorderLineStyle topBorder;
    private BorderLineStyle bottomBorder;
    private Colour backgroundColour;
    private Pattern pattern;
    private int options;
    private int xfIndex;
    private FontRecord font;
    private Format format;
    private boolean initialized;
    private boolean read;
    private static int[] dateFormats = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 45, 46, 47};
    private static DateFormat[] javaDateFormats = new DateFormat[]{new SimpleDateFormat("M/d/yy"), new SimpleDateFormat("d-MMM-yy"), new SimpleDateFormat("d-MMM"), new SimpleDateFormat("MMM-yy"), new SimpleDateFormat("h:mm a"), new SimpleDateFormat("h:mm:ss a"), new SimpleDateFormat("H:mm"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("M/d/yy H:mm"), new SimpleDateFormat("mm:ss"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("mm:ss.S")};
    private static int[] numberFormats = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 37, 38, 39, 40, 41, 42, 43, 44, 48};
    private static NumberFormat[] javaNumberFormats = new NumberFormat[]{new DecimalFormat("0"), new DecimalFormat("0.00"), new DecimalFormat("#,##0"), new DecimalFormat("#,##0.00"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("0%"), new DecimalFormat("0.00%"), new DecimalFormat("0.00E00"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("##0.0E0")};

    public XFRecord(Record t) {
        super(t);
        int i;
        byte[] data = this.getRecord().getData();
        this.fontIndex = IntegerHelper.getInt(data[0], data[1]);
        this.formatIndex = IntegerHelper.getInt(data[2], data[3]);
        this.date = false;
        this.number = false;
        for (i = 0; i < dateFormats.length; ++i) {
            if (this.formatIndex != dateFormats[i]) continue;
            this.date = true;
            this.dateFormat = javaDateFormats[i];
        }
        for (i = 0; i < numberFormats.length; ++i) {
            if (this.formatIndex != numberFormats[i]) continue;
            this.number = true;
            this.numberFormat = javaNumberFormats[i];
        }
        this.initialized = false;
        this.read = true;
    }

    public XFRecord(FontRecord fnt, Format form) {
        super(Type.XF);
        this.initialized = false;
        this.locked = true;
        this.hidden = false;
        this.align = Alignment.GENERAL;
        this.valign = VerticalAlignment.BOTTOM;
        this.orientation = 0;
        this.wrap = false;
        this.leftBorder = BorderLineStyle.NONE;
        this.rightBorder = BorderLineStyle.NONE;
        this.topBorder = BorderLineStyle.NONE;
        this.bottomBorder = BorderLineStyle.NONE;
        this.backgroundColour = Colour.DEFAULT_BACKGROUND;
        this.pattern = Pattern.NONE;
        this.font = fnt;
        this.format = form;
        this.read = false;
        Assert.verify(this.font != null);
        Assert.verify(this.format != null);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public int getFormatRecord() {
        return this.formatIndex;
    }

    public boolean isDate() {
        return this.date;
    }

    public boolean isNumber() {
        return this.number;
    }

    public byte[] getData() {
        if (this.read) {
            return this.getRecord().getData();
        }
        byte[] data = new byte[20];
        IntegerHelper.getTwoBytes(this.fontIndex, data, 0);
        IntegerHelper.getTwoBytes(this.formatIndex, data, 2);
        int alignMask = this.align.getValue();
        if (this.wrap) {
            alignMask |= 8;
        }
        alignMask |= this.valign.getValue() << 4;
        IntegerHelper.getTwoBytes(alignMask |= this.orientation << 8, data, 6);
        int borderMask = this.leftBorder.getValue();
        borderMask |= this.rightBorder.getValue() << 4;
        borderMask |= this.topBorder.getValue() << 8;
        IntegerHelper.getTwoBytes(borderMask |= this.bottomBorder.getValue() << 12, data, 10);
        IntegerHelper.getTwoBytes(this.pattern.getValue(), data, 16);
        int colourPaletteMask = this.backgroundColour.getValue();
        IntegerHelper.getTwoBytes(colourPaletteMask |= 0x2000, data, 18);
        IntegerHelper.getTwoBytes(this.options, data, 8);
        return data;
    }

    protected final boolean getLocked() {
        return this.locked;
    }

    protected final boolean getHidden() {
        return this.hidden;
    }

    public final void setLocked(boolean l) {
        this.locked = l;
    }

    protected final void setXFCellOptions(int opt) {
        this.options = opt;
    }

    protected void setXFAlignment(Alignment a) {
        Assert.verify(!this.initialized);
        this.align = a;
    }

    protected void setXFBackground(Colour c, Pattern p) {
        Assert.verify(!this.initialized);
        this.backgroundColour = c;
        this.pattern = p;
    }

    protected void setXFVerticalAlignment(VerticalAlignment va) {
        Assert.verify(!this.initialized);
        this.valign = va;
    }

    protected void setXFWrap(boolean w) {
        Assert.verify(!this.initialized);
        this.wrap = w;
    }

    protected void setXFBorder(Border b, BorderLineStyle ls) {
        Assert.verify(!this.initialized);
        if (b == Border.LEFT) {
            this.leftBorder = ls;
        } else if (b == Border.RIGHT) {
            this.rightBorder = ls;
        } else if (b == Border.TOP) {
            this.topBorder = ls;
        } else if (b == Border.BOTTOM) {
            this.bottomBorder = ls;
        }
    }

    public final void initialize(int pos, FormattingRecords fr, Fonts fonts) {
        this.xfIndex = pos;
        if (this.read) {
            this.initialized = true;
            return;
        }
        if (!this.font.isInitialized()) {
            fonts.addFont(this.font);
        }
        if (!this.format.isInitialized()) {
            fr.addFormat(this.format);
        }
        this.fontIndex = this.font.getFontIndex();
        this.formatIndex = this.format.getFormatIndex();
        this.initialized = true;
    }

    public final void uninitialize() {
        this.initialized = false;
    }

    public final int getXFIndex() {
        return this.xfIndex;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }
}

