/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import jxl.BooleanCell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.read.biff.CellValue;
import jxl.read.biff.Formula;
import jxl.read.biff.Record;

class BooleanFormulaRecord
extends CellValue
implements BooleanCell,
Formula {
    private boolean value = false;
    private byte[] data = this.getRecord().getData();

    public BooleanFormulaRecord(Record t, FormattingRecords fr) {
        super(t, fr);
        Assert.verify(this.data[6] != 2);
        this.value = this.data[8] == 1;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getContents() {
        return new Boolean(this.value).toString();
    }

    public CellType getType() {
        return CellType.BOOLEAN_FORMULA;
    }

    public byte[] getFormulaData() {
        return this.data;
    }
}

