/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.io.IOException;
import java.io.InputStream;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;
import jxl.read.biff.Record;

public class File {
    private byte[] data;
    private int pos;
    private int oldPos;
    private static final int initialFileSize = 0x500000;
    private static final int arrayGrowSize = 0x100000;

    public File(InputStream is) throws BiffException, IOException {
        int bytesRead;
        byte[] d = new byte[0x500000];
        int pos = bytesRead = is.read(d);
        while (bytesRead != -1) {
            if (pos >= d.length) {
                byte[] newArray = new byte[d.length + 0x100000];
                System.arraycopy(d, 0, newArray, 0, d.length);
                d = newArray;
            }
            bytesRead = is.read(d, pos, d.length - pos);
            pos += bytesRead;
        }
        bytesRead = pos + 1;
        if (bytesRead == 0) {
            throw new BiffException(BiffException.excelFileNotFound);
        }
        CompoundFile cf = new CompoundFile(d);
        try {
            this.data = cf.getStream("workbook");
        }
        catch (BiffException e) {
            this.data = cf.getStream("book");
        }
        cf = null;
        System.gc();
    }

    Record next() {
        Record r = new Record(this.data, this.pos, this);
        return r;
    }

    Record peek() {
        int tempPos = this.pos;
        Record r = new Record(this.data, this.pos, this);
        this.pos = tempPos;
        return r;
    }

    public void skip(int bytes) {
        this.pos += bytes;
    }

    public byte[] read(int pos, int length) {
        byte[] ret = new byte[length];
        System.arraycopy(this.data, pos, ret, 0, length);
        return ret;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int p) {
        this.oldPos = this.pos;
        this.pos = p;
    }

    public void restorePos() {
        this.pos = this.oldPos;
    }

    private void moveToFirstBof() {
        boolean bofFound = false;
        while (!bofFound) {
            int code = IntegerHelper.getInt(this.data[this.pos], this.data[this.pos + 1]);
            if (code == Type.BOF.value) {
                bofFound = true;
                continue;
            }
            this.skip(128);
        }
    }

    public void close() {
    }

    public void clear() {
        this.data = null;
    }

    public boolean hasNext() {
        return this.pos < this.data.length - 4;
    }

    static {
        initialFileSize = 0x500000;
        arrayGrowSize = 0x100000;
    }
}

