/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.read.biff.CellValue;
import jxl.read.biff.Formula;
import jxl.read.biff.Record;

class NumberFormulaRecord
extends CellValue
implements NumberCell,
Formula {
    private double value;
    private static DecimalFormat format = new DecimalFormat("#.###");
    private byte[] data = this.getRecord().getData();

    public NumberFormulaRecord(Record t, FormattingRecords fr) {
        super(t, fr);
        int num1 = IntegerHelper.getInt(this.data[6], this.data[7], this.data[8], this.data[9]);
        int num2 = IntegerHelper.getInt(this.data[10], this.data[11], this.data[12], this.data[13]);
        String s1 = Integer.toBinaryString(num1);
        while (s1.length() < 32) {
            s1 = "0".concat(String.valueOf(String.valueOf(s1)));
        }
        boolean negative = (num2 & Integer.MIN_VALUE) != 0;
        String s = String.valueOf(String.valueOf(Integer.toBinaryString(num2 & Integer.MAX_VALUE))).concat(String.valueOf(String.valueOf(s1)));
        long val = Long.parseLong(s, 2);
        this.value = Double.longBitsToDouble(val);
        if (negative) {
            this.value = -this.value;
        }
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public byte[] getFormulaData() {
        return this.data;
    }
}

