/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.read.biff.CellValue;
import jxl.read.biff.Record;

class NumberRecord
extends CellValue
implements NumberCell {
    private double value;
    private NumberFormat format;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public NumberRecord(Record t, FormattingRecords fr) {
        super(t, fr);
        byte[] data = this.getRecord().getData();
        int num1 = IntegerHelper.getInt(data[6], data[7], data[8], data[9]);
        int num2 = IntegerHelper.getInt(data[10], data[11], data[12], data[13]);
        String s1 = Integer.toBinaryString(num1);
        while (s1.length() < 32) {
            s1 = "0".concat(String.valueOf(String.valueOf(s1)));
        }
        boolean negative = (num2 & Integer.MIN_VALUE) != 0;
        String s = String.valueOf(String.valueOf(Integer.toBinaryString(num2 & Integer.MAX_VALUE))).concat(String.valueOf(String.valueOf(s1)));
        long val = Long.parseLong(s, 2);
        this.value = Double.longBitsToDouble(val);
        if (negative) {
            this.value = -this.value;
        }
        this.format = fr.getNumberFormat(this.getXFIndex());
        if (this.format == null) {
            this.format = defaultFormat;
        }
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER;
    }
}

