/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.FormattingRecords;

class NumberValue
implements NumberCell {
    private int row;
    private int column;
    private double value;
    private NumberFormat format;
    private CellFormat cellFormat;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public NumberValue(int r, int c, double val, int xfi, FormattingRecords fr) {
        this.row = r;
        this.column = c;
        this.value = val;
        this.format = defaultFormat;
        this.xfIndex = xfi;
        this.formattingRecords = fr;
        this.initialized = false;
    }

    final void setNumberFormat(NumberFormat f) {
        if (f != null) {
            this.format = f;
        }
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.cellFormat = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.cellFormat;
    }
}

