/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.LabelCell;
import jxl.Sheet;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.RecordData;
import jxl.biff.Type;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BiffException;
import jxl.read.biff.BooleanRecord;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.DimensionRecord;
import jxl.read.biff.ErrorRecord;
import jxl.read.biff.File;
import jxl.read.biff.FormulaRecord;
import jxl.read.biff.LabelRecord;
import jxl.read.biff.LabelSSTRecord;
import jxl.read.biff.MulRKRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.NumberRecord;
import jxl.read.biff.NumberValue;
import jxl.read.biff.RKHelper;
import jxl.read.biff.RKRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SSTRecord;

public class SheetImpl
implements Sheet {
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord bofRecord;
    private FormattingRecords formattingRecords;
    private String name;
    private boolean hidden;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ColumnInfoRecord[] columnInfos;
    private ArrayList columnInfosArray;
    private boolean columnInfosInitialized;
    private boolean nineteenFour;

    SheetImpl(File f, SSTRecord sst, FormattingRecords fr, BOFRecord br, boolean nf) throws BiffException {
        this.excelFile = f;
        this.sharedStrings = sst;
        this.formattingRecords = fr;
        this.bofRecord = br;
        this.columnInfosArray = new ArrayList();
        this.columnInfosInitialized = false;
        this.nineteenFour = nf;
        this.startPosition = f.getPos();
        Record r = null;
        int bofs = 1;
        while (bofs >= 1) {
            r = f.next();
            if (r.getCode() == Type.EOF.value) {
                --bofs;
            }
            if (r.getCode() != Type.BOF.value) continue;
            ++bofs;
        }
    }

    public Cell getCell(int column, int row) {
        Cell c;
        if (this.cells == null) {
            this.readSheet();
        }
        if ((c = this.cells[row][column]) == null) {
            c = new EmptyCell(column, row);
            this.addCell(c);
        }
        return c;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (!row[j].getContents().equals(contents)) continue;
                cell = row[j];
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (row[j].getType() != CellType.LABEL && row[j].getType() != CellType.STRING_FORMULA || !row[j].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j];
                found = true;
            }
        }
        return cell;
    }

    public int getRows() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numRows;
    }

    public int getColumns() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numCols;
    }

    public Cell[] getRow(int row) {
        if (this.cells == null) {
            this.readSheet();
        }
        Cell[] cells = new Cell[this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            cells[i] = this.getCell(i, row);
        }
        return cells;
    }

    public Cell[] getColumn(int col) {
        if (this.cells == null) {
            this.readSheet();
        }
        Cell[] cells = new Cell[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            cells[i] = this.getCell(col, i);
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    final void setName(String s) {
        this.name = s;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnInfoRecord getColumnInfo(int col) {
        if (!this.columnInfosInitialized) {
            Iterator i = ((AbstractList)this.columnInfosArray).iterator();
            ColumnInfoRecord cir = null;
            while (i.hasNext()) {
                cir = (ColumnInfoRecord)i.next();
                for (int c = cir.getStartColumn(); c <= cir.getEndColumn(); ++c) {
                    this.columnInfos[c] = cir;
                }
            }
            this.columnInfosInitialized = true;
        }
        return this.columnInfos[col];
    }

    final void setHidden(boolean h) {
        this.hidden = h;
    }

    final void clear() {
        this.cells = null;
        System.gc();
    }

    private void addCell(Cell cell) {
        Assert.verify(this.cells[cell.getRow()][cell.getColumn()] == null);
        this.cells[cell.getRow()][cell.getColumn()] = cell;
    }

    final void readSheet() {
        if (!this.bofRecord.isWorksheet()) {
            this.numRows = 0;
            this.numCols = 0;
            this.cells = new Cell[0][0];
            return;
        }
        Record r = null;
        boolean cont = true;
        this.excelFile.setPos(this.startPosition);
        while (cont) {
            RecordData br;
            DateRecord dc;
            r = this.excelFile.next();
            if (r.getType() == Type.DIMENSION) {
                DimensionRecord dr = null;
                dr = this.bofRecord.isBiff8() ? new DimensionRecord(r) : new DimensionRecord(r, DimensionRecord.biff7);
                this.numRows = dr.getNumberOfRows();
                this.numCols = dr.getNumberOfColumns();
                this.cells = new Cell[this.numRows][this.numCols];
                this.columnInfos = new ColumnInfoRecord[this.numCols];
            }
            if (r.getType() == Type.LABELSST) {
                LabelSSTRecord label = new LabelSSTRecord(r, this.sharedStrings, this.formattingRecords);
                this.addCell(label);
            }
            if (r.getType() == Type.RK || r.getType() == Type.RK2) {
                RKRecord rkr = new RKRecord(r, this.formattingRecords);
                if (this.formattingRecords.isDate(rkr.getXFIndex())) {
                    dc = new DateRecord(rkr, rkr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                    this.addCell(dc);
                } else {
                    this.addCell(rkr);
                }
            }
            if (r.getType() == Type.MULRK) {
                MulRKRecord mulrk = new MulRKRecord(r);
                int num = mulrk.getNumberOfColumns();
                int ixf = 0;
                for (int i = 0; i < num; ++i) {
                    ixf = mulrk.getXFIndex(i);
                    NumberValue nv = new NumberValue(mulrk.getRow(), mulrk.getFirstColumn() + i, RKHelper.getDouble(mulrk.getRKNumber(i)), ixf, this.formattingRecords);
                    if (this.formattingRecords.isDate(ixf)) {
                        DateRecord dc2 = new DateRecord(nv, ixf, this.formattingRecords, this.nineteenFour);
                        this.addCell(dc2);
                        continue;
                    }
                    nv.setNumberFormat(this.formattingRecords.getNumberFormat(ixf));
                    this.addCell(nv);
                }
            }
            if (r.getType() == Type.ROW) {
                // empty if block
            }
            if (r.getType() == Type.NUMBER) {
                NumberRecord nr = new NumberRecord(r, this.formattingRecords);
                if (this.formattingRecords.isDate(nr.getXFIndex())) {
                    dc = new DateRecord(nr, nr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                    this.addCell(dc);
                } else {
                    this.addCell(nr);
                }
            }
            if (r.getType() == Type.BOOLERR) {
                br = new BooleanRecord(r, this.formattingRecords);
                if (((BooleanRecord)br).isError()) {
                    ErrorRecord er = new ErrorRecord(((BooleanRecord)br).getRecord(), this.formattingRecords);
                    this.addCell(er);
                } else {
                    this.addCell((Cell)((Object)br));
                }
            }
            if (r.getType() == Type.CONTINUE) {
                // empty if block
            }
            if (r.getType() == Type.NOTE) {
                // empty if block
            }
            if (r.getType() == Type.FORMULA || r.getType() == Type.FORMULA2) {
                NumberFormulaRecord nfr;
                FormulaRecord fr = new FormulaRecord(r, this.excelFile, this.formattingRecords);
                Cell cell = fr.getFormula();
                if (fr.getFormula().getType() == CellType.NUMBER_FORMULA && this.formattingRecords.isDate((nfr = (NumberFormulaRecord)fr.getFormula()).getXFIndex())) {
                    cell = new DateRecord(nfr, nfr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                }
                this.addCell(cell);
            }
            if (r.getType() == Type.LABEL) {
                LabelRecord lr = null;
                lr = this.bofRecord.isBiff8() ? new LabelRecord(r, this.formattingRecords) : new LabelRecord(r, this.formattingRecords, LabelRecord.biff7);
                this.addCell(lr);
            }
            if (r.getType() == Type.NAME) {
                // empty if block
            }
            if (r.getType() == Type.COLINFO) {
                ColumnInfoRecord cir = new ColumnInfoRecord(r);
                this.columnInfosArray.add(cir);
            }
            if (r.getType() == Type.BOF) {
                br = new BOFRecord(r);
                Assert.verify(!((BOFRecord)br).isWorksheet());
                Record r2 = this.excelFile.next();
                while (r2.getCode() != Type.EOF.value) {
                    r2 = this.excelFile.next();
                }
            }
            if (r.getType() != Type.EOF) continue;
            cont = false;
        }
        this.excelFile.restorePos();
    }
}

