/*
 * Decompiled with CFR 0.152.
 */
package jxl.write;

import jxl.biff.FontRecord;
import jxl.write.Colour;

public class Font
extends FontRecord {
    public static FontName ARIAL = new FontName("Arial");
    public static FontName TIMES = new FontName("Times New Roman");
    public static final BoldStyle NO_BOLD = new BoldStyle(400);
    public static final BoldStyle BOLD = new BoldStyle(700);
    public static final UnderlineStyle NO_UNDERLINE = new UnderlineStyle(0);
    public static final UnderlineStyle SINGLE = new UnderlineStyle(1);
    public static final UnderlineStyle DOUBLE = new UnderlineStyle(2);
    public static final UnderlineStyle SINGLE_ACCOUNTING = new UnderlineStyle(33);
    public static final UnderlineStyle DOUBLE_ACCOUNTING = new UnderlineStyle(34);
    public static final ScriptStyle NORMAL_SCRIPT = new ScriptStyle(0);
    public static final ScriptStyle SUPERSCRIPT = new ScriptStyle(1);
    public static final ScriptStyle SUBSCRIPT = new ScriptStyle(2);
    public static final int DEFAULT_POINT_SIZE = 10;

    public Font(FontName fn) {
        this(fn, 10, NO_BOLD, false, NO_UNDERLINE, Colour.BLACK, NORMAL_SCRIPT);
    }

    public Font(FontName fn, int ps) {
        this(fn, ps, NO_BOLD, false, NO_UNDERLINE, Colour.BLACK, NORMAL_SCRIPT);
    }

    public Font(FontName fn, int ps, BoldStyle bs) {
        this(fn, ps, bs, false, NO_UNDERLINE, Colour.BLACK, NORMAL_SCRIPT);
    }

    public Font(FontName fn, int ps, BoldStyle bs, boolean italic) {
        this(fn, ps, bs, italic, NO_UNDERLINE, Colour.BLACK, NORMAL_SCRIPT);
    }

    public Font(FontName fn, int ps, BoldStyle bs, boolean it, UnderlineStyle us) {
        this(fn, ps, bs, it, us, Colour.BLACK, NORMAL_SCRIPT);
    }

    public Font(FontName fn, int ps, BoldStyle bs, boolean it, UnderlineStyle us, Colour c) {
        this(fn, ps, bs, it, us, c, NORMAL_SCRIPT);
    }

    public Font(FontName fn, int ps, BoldStyle bs, boolean it, UnderlineStyle us, Colour c, ScriptStyle ss) {
        super(fn.name, ps, bs.value, it, us.value, c.getValue(), ss.value);
    }

    static {
        DEFAULT_POINT_SIZE = 10;
    }

    private static class UnderlineStyle {
        public int value;

        private UnderlineStyle(int val) {
            this.value = val;
        }
    }

    private static class ScriptStyle {
        public int value;

        private ScriptStyle(int val) {
            this.value = val;
        }
    }

    private static class BoldStyle {
        public int value;

        BoldStyle(int val) {
            this.value = val;
        }
    }

    private static class FontName {
        public String name;

        FontName(String s) {
            this.name = s;
        }
    }
}

