/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import jxl.Cell;
import jxl.CellFormat;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.write.WritableCell;
import jxl.write.WritableWorkbook;

public abstract class CellValue
extends WritableRecordData
implements WritableCell {
    private int row;
    private int column;
    private XFRecord format;
    private FormattingRecords formattingRecords;
    private boolean referenced;

    protected CellValue(Type t, int c, int r) {
        this(t, c, r, WritableWorkbook.NORMAL_STYLE);
    }

    protected CellValue(Type t, Cell c) {
        this(t, c.getColumn(), c.getRow());
        this.format = (XFRecord)c.getCellFormat();
    }

    protected CellValue(Type t, int c, int r, CellFormat st) {
        super(t);
        this.row = r;
        this.column = c;
        this.format = (XFRecord)st;
        this.referenced = false;
    }

    public void setCellFormat(CellFormat cf) {
        this.format = (XFRecord)cf;
        if (!this.referenced) {
            return;
        }
        Assert.verify(this.formattingRecords != null);
        if (!this.format.isInitialized()) {
            this.formattingRecords.addStyle(this.format);
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public byte[] getData() {
        byte[] mydata = new byte[6];
        IntegerHelper.getTwoBytes(this.row, mydata, 0);
        IntegerHelper.getTwoBytes(this.column, mydata, 2);
        IntegerHelper.getTwoBytes(this.format.getXFIndex(), mydata, 4);
        return mydata;
    }

    void setCellDetails(FormattingRecords fr) {
        this.referenced = true;
        if (!this.format.isInitialized()) {
            fr.addStyle(this.format);
        }
        this.formattingRecords = fr;
    }

    final boolean isReferenced() {
        return this.referenced;
    }

    final int getXFIndex() {
        return this.format.getXFIndex();
    }

    public CellFormat getCellFormat() {
        return this.format;
    }

    public abstract String getContents();

    public abstract CellType getType();
}

