/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.FontRecord;
import jxl.biff.Format;
import jxl.biff.IntegerHelper;
import jxl.biff.XFRecord;
import jxl.write.Alignment;
import jxl.write.Border;
import jxl.write.BorderLineStyle;
import jxl.write.Colour;
import jxl.write.Pattern;
import jxl.write.VerticalAlignment;
import jxl.write.WriteException;
import jxl.write.biff.JxlWriteException;

public class CellXFRecord
extends XFRecord {
    private int backgroundPattern = 0;

    protected CellXFRecord(FontRecord fnt, Format form) {
        super(fnt, form);
    }

    public byte[] getData() {
        byte[] data = super.getData();
        int cellAttributes = 0;
        if (this.getLocked()) {
            cellAttributes |= 1;
        }
        if (this.getHidden()) {
            cellAttributes |= 2;
        }
        IntegerHelper.getTwoBytes(cellAttributes, data, 4);
        return data;
    }

    public void setAlignment(Alignment a) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFAlignment(a);
    }

    public void setBackground(Colour c, Pattern p) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFBackground(c, p);
        super.setXFCellOptions(16384);
    }

    public void setVerticalAlignment(VerticalAlignment va) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFVerticalAlignment(va);
    }

    public void setWrap(boolean w) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFWrap(w);
    }

    public void setBorder(Border b, BorderLineStyle ls) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        if (b == Border.ALL) {
            super.setXFBorder(Border.LEFT, ls);
            super.setXFBorder(Border.RIGHT, ls);
            super.setXFBorder(Border.TOP, ls);
            super.setXFBorder(Border.BOTTOM, ls);
            return;
        }
        if (b == Border.NONE) {
            super.setXFBorder(Border.LEFT, BorderLineStyle.NONE);
            super.setXFBorder(Border.RIGHT, BorderLineStyle.NONE);
            super.setXFBorder(Border.TOP, BorderLineStyle.NONE);
            super.setXFBorder(Border.BOTTOM, BorderLineStyle.NONE);
            return;
        }
        super.setXFBorder(b, ls);
    }
}

