/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;

class ColumnInfoRecord
extends WritableRecordData {
    private byte[] data;
    private int column;
    private XFRecord style;
    private int xfIndex;
    private int width;

    public ColumnInfoRecord(int col, int w, XFRecord xf) {
        super(Type.COLINFO);
        this.column = col;
        this.width = w * 256;
        this.style = xf;
        this.xfIndex = this.style.getXFIndex();
    }

    public ColumnInfoRecord(jxl.read.biff.ColumnInfoRecord cir, int col) {
        super(Type.COLINFO);
        this.column = col;
        this.width = cir.getWidth() * 256;
        this.xfIndex = cir.getXFIndex();
    }

    public int getColumn() {
        return this.column;
    }

    public byte[] getData() {
        this.data = new byte[12];
        IntegerHelper.getTwoBytes(this.column, this.data, 0);
        IntegerHelper.getTwoBytes(this.column, this.data, 2);
        IntegerHelper.getTwoBytes(this.width, this.data, 4);
        IntegerHelper.getTwoBytes(this.xfIndex, this.data, 6);
        IntegerHelper.getTwoBytes(2, this.data, 8);
        IntegerHelper.getTwoBytes(2, this.data, 10);
        return this.data;
    }
}

