/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.io.OutputStream;
import jxl.biff.WritableRecordData;
import jxl.write.biff.CompoundFile;

public final class File {
    private byte[] data = new byte[0x500000];
    private int pos = 0;
    private OutputStream outputStream;
    private static final int initialFileSize = 0x500000;
    private static final int arrayGrowSize = 0x100000;

    File(OutputStream os) {
        this.outputStream = os;
    }

    void close() throws IOException {
        CompoundFile cf = new CompoundFile(this.data, this.pos, this.outputStream);
        cf.write();
        this.outputStream.close();
        this.data = null;
        System.gc();
    }

    public void write(WritableRecordData record) throws IOException {
        byte[] bytes = record.getBytes();
        if (this.pos + bytes.length > this.data.length) {
            byte[] newdata = new byte[this.data.length + 0x100000];
            System.arraycopy(this.data, 0, newdata, 0, this.pos);
            this.data = newdata;
        }
        System.arraycopy(bytes, 0, this.data, this.pos, bytes.length);
        this.pos += bytes.length;
    }

    int getPos() {
        return this.pos;
    }

    void setData(byte[] newdata, int pos) {
        System.arraycopy(newdata, 0, this.data, pos, newdata.length);
    }

    static {
        initialFileSize = 0x500000;
        arrayGrowSize = 0x100000;
    }
}

