/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.CellFormat;
import jxl.CellType;
import jxl.LabelCell;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.write.biff.CellValue;

public class LabelRecord
extends CellValue {
    private String contents;

    protected LabelRecord(int c, int r, String cont) {
        super(Type.LABEL, c, r);
        this.contents = cont;
        if (this.contents == null) {
            this.contents = "";
        }
    }

    protected LabelRecord(int c, int r, String cont, CellFormat st) {
        super(Type.LABEL, c, r, st);
        this.contents = cont;
        if (this.contents == null) {
            this.contents = "";
        }
    }

    protected LabelRecord(LabelCell lc) {
        super(Type.LABEL, lc);
        this.contents = lc.getString();
        if (this.contents == null) {
            this.contents = "";
        }
    }

    public CellType getType() {
        return CellType.LABEL;
    }

    public byte[] getData() {
        byte[] celldata = super.getData();
        byte[] data = new byte[celldata.length + this.contents.length() * 2 + 3];
        System.arraycopy(celldata, 0, data, 0, celldata.length);
        data[celldata.length + 2] = 1;
        IntegerHelper.getTwoBytes(this.contents.length(), data, celldata.length);
        StringHelper.getUnicodeBytes(this.contents, data, celldata.length + 3);
        return data;
    }

    public String getContents() {
        return this.contents;
    }

    public String getString() {
        return this.contents;
    }

    protected void setString(String s) {
        this.contents = s;
    }
}

