/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.CellType;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.Number;
import jxl.write.biff.CellValue;
import jxl.write.biff.File;
import jxl.write.biff.MulRKRecord;

class RowRecord
extends WritableRecordData {
    private byte[] data;
    private CellValue[] cells;
    private int rowHeight;
    private boolean outlineCollapsed;
    private boolean zeroHeight;
    private int rowNumber;
    private int maxColumn;
    private static final int growSize = 10;

    public RowRecord(int rn) {
        super(Type.ROW);
        this.rowNumber = rn;
        this.cells = new CellValue[0];
        this.maxColumn = 0;
        this.rowHeight = 255;
        this.outlineCollapsed = false;
        this.zeroHeight = false;
    }

    public void setRowHeight(int h) {
        this.rowHeight = h;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void addCell(CellValue cv) {
        int col = cv.getColumn();
        if (col >= this.cells.length) {
            CellValue[] oldCells = this.cells;
            this.cells = new CellValue[Math.max(oldCells.length + 10, col + 1)];
            System.arraycopy(oldCells, 0, this.cells, 0, oldCells.length);
            Object var3_3 = null;
        }
        this.cells[col] = cv;
        this.maxColumn = Math.max(col + 1, this.maxColumn);
    }

    public void removeCell(int col) {
        if (col >= this.maxColumn) {
            return;
        }
        this.cells[col] = null;
    }

    public void write(File outputFile) throws IOException {
        outputFile.write(this);
    }

    public void writeCells(File outputFile) throws IOException {
        ArrayList<CellValue> integerValues = new ArrayList<CellValue>();
        boolean integerValue = false;
        for (int i = 0; i < this.maxColumn; ++i) {
            integerValue = false;
            if (this.cells[i] != null) {
                Number nc;
                if (this.cells[i].getType() == CellType.NUMBER && (nc = (Number)this.cells[i]).getValue() == (double)((int)nc.getValue())) {
                    integerValue = true;
                }
                if (integerValue) {
                    integerValues.add(this.cells[i]);
                    continue;
                }
                this.writeIntegerValues(integerValues, outputFile);
                outputFile.write(this.cells[i]);
                continue;
            }
            this.writeIntegerValues(integerValues, outputFile);
        }
        this.writeIntegerValues(integerValues, outputFile);
    }

    private void writeIntegerValues(ArrayList integerValues, File outputFile) throws IOException {
        if (integerValues.size() == 0) {
            return;
        }
        if (integerValues.size() >= 3) {
            MulRKRecord mulrk = new MulRKRecord(integerValues);
            outputFile.write(mulrk);
        } else {
            Iterator i = ((AbstractList)integerValues).iterator();
            while (i.hasNext()) {
                outputFile.write((CellValue)i.next());
            }
        }
        integerValues.clear();
    }

    public byte[] getData() {
        byte[] data = new byte[16];
        IntegerHelper.getTwoBytes(this.rowNumber, data, 0);
        IntegerHelper.getTwoBytes(this.maxColumn, data, 4);
        IntegerHelper.getTwoBytes(this.rowHeight, data, 6);
        if (this.outlineCollapsed) {
            data[15] = (byte)(data[15] | 4);
        }
        if (this.zeroHeight) {
            data[15] = (byte)(data[15] | 8);
        }
        return data;
    }

    public int getMaxColumn() {
        return this.maxColumn;
    }

    public CellValue getCell(int col) {
        return col >= 0 && col <= this.maxColumn ? this.cells[col] : null;
    }

    static {
        growSize = 10;
    }
}

