/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Sheet;
import jxl.Workbook;
import jxl.biff.Fonts;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.read.biff.WorkbookParser;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.BackupRecord;
import jxl.write.biff.BookboolRecord;
import jxl.write.biff.BoundsheetRecord;
import jxl.write.biff.CodepageRecord;
import jxl.write.biff.CountryRecord;
import jxl.write.biff.DSFRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.ExtendedSSTRecord;
import jxl.write.biff.File;
import jxl.write.biff.FunctionGroupCountRecord;
import jxl.write.biff.HideobjRecord;
import jxl.write.biff.InterfaceEndRecord;
import jxl.write.biff.InterfaceHeaderRecord;
import jxl.write.biff.MMSRecord;
import jxl.write.biff.NineteenFourRecord;
import jxl.write.biff.PasswordRecord;
import jxl.write.biff.PrecisionRecord;
import jxl.write.biff.Prot4RevPassRecord;
import jxl.write.biff.Prot4RevRecord;
import jxl.write.biff.ProtectRecord;
import jxl.write.biff.RefreshAllRecord;
import jxl.write.biff.SSTRecord;
import jxl.write.biff.TabIdRecord;
import jxl.write.biff.UsesElfsRecord;
import jxl.write.biff.Window1Record;
import jxl.write.biff.WindowProtectRecord;
import jxl.write.biff.WritableFonts;
import jxl.write.biff.WritableFormattingRecords;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WriteAccessRecord;

public class WritableWorkbookImpl
extends WritableWorkbook {
    private FormattingRecords formatRecords;
    private File outputFile;
    private ArrayList sheets;
    private Fonts fonts;

    public WritableWorkbookImpl(OutputStream os) throws IOException {
        this.outputFile = new File(os);
        this.sheets = new ArrayList();
        WritableWorkbook.ARIAL_10_PT.uninitialize();
        WritableWorkbook.NORMAL_STYLE.uninitialize();
        WritableFonts wf = new WritableFonts();
        this.fonts = wf;
        WritableFormattingRecords wfr = new WritableFormattingRecords(this.fonts);
        this.formatRecords = wfr;
    }

    public WritableWorkbookImpl(OutputStream os, Workbook w) throws IOException {
        WorkbookParser wp = (WorkbookParser)w;
        WritableWorkbook.ARIAL_10_PT.uninitialize();
        WritableWorkbook.NORMAL_STYLE.uninitialize();
        this.outputFile = new File(os);
        this.sheets = new ArrayList();
        this.fonts = wp.getFonts();
        this.formatRecords = wp.getFormattingRecords();
    }

    public WritableSheet[] getSheets() {
        return null;
    }

    public WritableSheet getSheet(int index) {
        return (WritableSheet)this.sheets.get(index);
    }

    public WritableSheet getSheet(String name) {
        boolean found = false;
        Iterator i = ((AbstractList)this.sheets).iterator();
        WritableSheet s = null;
        while (i.hasNext() && !found) {
            s = (WritableSheet)i.next();
            if (!s.getName().equals(name)) continue;
            found = true;
        }
        return found ? s : null;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public void close() throws IOException {
        this.outputFile.close();
    }

    public WritableSheet createSheet(String name, int index) {
        WritableSheetImpl w = new WritableSheetImpl(name, this.outputFile, this.formatRecords, this.fonts);
        if (index <= 0) {
            this.sheets.add(0, w);
        } else if (index > this.sheets.size()) {
            this.sheets.add(w);
        } else {
            this.sheets.add(index, w);
        }
        return w;
    }

    public void removeSheet(int index) {
        if (index <= 0) {
            this.sheets.remove(0);
        } else if (index >= this.sheets.size()) {
            this.sheets.remove(this.sheets.size() - 1);
        } else {
            this.sheets.remove(index);
        }
    }

    public void write() throws IOException {
        BOFRecord bof = new BOFRecord(BOFRecord.workbookGlobals);
        this.outputFile.write(bof);
        InterfaceHeaderRecord ihr = new InterfaceHeaderRecord();
        this.outputFile.write(ihr);
        MMSRecord mms = new MMSRecord(0, 0);
        this.outputFile.write(mms);
        InterfaceEndRecord ier = new InterfaceEndRecord();
        this.outputFile.write(ier);
        WriteAccessRecord wr = new WriteAccessRecord();
        this.outputFile.write(wr);
        CodepageRecord cp = new CodepageRecord();
        this.outputFile.write(cp);
        DSFRecord dsf = new DSFRecord();
        this.outputFile.write(dsf);
        TabIdRecord tabid = new TabIdRecord();
        this.outputFile.write(tabid);
        FunctionGroupCountRecord fgcr = new FunctionGroupCountRecord();
        this.outputFile.write(fgcr);
        WindowProtectRecord wpr = new WindowProtectRecord(false);
        this.outputFile.write(wpr);
        ProtectRecord pr = new ProtectRecord(false);
        this.outputFile.write(pr);
        PasswordRecord pw = new PasswordRecord(null);
        this.outputFile.write(pw);
        Prot4RevRecord p4r = new Prot4RevRecord(false);
        this.outputFile.write(p4r);
        Prot4RevPassRecord p4rp = new Prot4RevPassRecord();
        this.outputFile.write(p4rp);
        Window1Record w1r = new Window1Record();
        this.outputFile.write(w1r);
        BackupRecord bkr = new BackupRecord(false);
        this.outputFile.write(bkr);
        HideobjRecord ho = new HideobjRecord(false);
        this.outputFile.write(ho);
        NineteenFourRecord nf = new NineteenFourRecord(false);
        this.outputFile.write(nf);
        PrecisionRecord pc = new PrecisionRecord(false);
        this.outputFile.write(pc);
        RefreshAllRecord rar = new RefreshAllRecord(true);
        this.outputFile.write(rar);
        BookboolRecord bb = new BookboolRecord(true);
        this.outputFile.write(bb);
        this.fonts.write(this.outputFile);
        this.formatRecords.write(this.outputFile);
        UsesElfsRecord uer = new UsesElfsRecord();
        this.outputFile.write(uer);
        int[] boundsheetPos = new int[this.getNumberOfSheets()];
        WritableSheet sheet = null;
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            boundsheetPos[i] = this.outputFile.getPos();
            sheet = this.getSheet(i);
            BoundsheetRecord br = new BoundsheetRecord(sheet.getName(), sheet.isHidden());
            this.outputFile.write(br);
        }
        CountryRecord cr = new CountryRecord();
        this.outputFile.write(cr);
        SSTRecord sst = new SSTRecord();
        this.outputFile.write(sst);
        ExtendedSSTRecord extsst = new ExtendedSSTRecord();
        this.outputFile.write(extsst);
        EOFRecord eof = new EOFRecord();
        this.outputFile.write(eof);
        WritableSheetImpl wsheet = null;
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            this.outputFile.setData(IntegerHelper.getFourBytes(this.outputFile.getPos()), boundsheetPos[i] + 4);
            wsheet = (WritableSheetImpl)this.getSheet(i);
            wsheet.write();
        }
    }

    public void copy(Workbook w) {
        int numSheets = w.getNumberOfSheets();
        Sheet s = null;
        WritableSheetImpl ws = null;
        for (int i = 0; i < numSheets; ++i) {
            s = w.getSheet(i);
            ws = (WritableSheetImpl)this.createSheet(s.getName(), i);
            ws.copy(s);
        }
    }
}

