/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Gif;
import com.lowagie.text.ImgCCITT;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Jpeg;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Png;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public abstract class Image
extends Rectangle
implements Element,
MarkupAttributes {
    public static final int DEFAULT = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int MIDDLE = 3;
    public static final int TEXTWRAP = 4;
    public static final int UNDERLYING = 8;
    public static final int AX = 0;
    public static final int AY = 1;
    public static final int BX = 2;
    public static final int BY = 3;
    public static final int CX = 4;
    public static final int CY = 5;
    public static final int DX = 6;
    public static final int DY = 7;
    protected boolean invert = false;
    protected int type;
    protected URL url;
    protected byte[] rawData;
    protected PdfTemplate[] template = new PdfTemplate[1];
    protected int alignment;
    protected String alt;
    protected float absoluteX = Float.NaN;
    protected float absoluteY = Float.NaN;
    protected float plainWidth;
    protected float plainHeight;
    protected float scaledWidth;
    protected float scaledHeight;
    protected float rotation;
    protected int colorspace = -1;
    protected int bpc = 1;
    protected int[] transparency;
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected Long mySerialId = Image.getSerialId();
    static long serialId = 0L;
    protected int dpiX = 0;
    protected int dpiY = 0;
    protected boolean mask = false;
    protected Image imageMask;
    protected boolean interpolation;
    protected Annotation annotation = null;
    protected Properties markupAttributes;
    protected ICC_Profile profile = null;
    protected boolean deflated = false;
    private PdfDictionary additional = null;
    private boolean smask;
    private float XYRatio = 0.0f;
    static /* synthetic */ Class class$com$lowagie$text$Image;

    public Image(URL uRL) {
        super(0.0f, 0.0f);
        this.url = uRL;
        this.alignment = 0;
        this.rotation = 0.0f;
    }

    protected Image(Image image) {
        super(image);
        this.type = image.type;
        this.url = image.url;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.absoluteX = image.absoluteX;
        this.absoluteY = image.absoluteY;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.scaledWidth = image.scaledWidth;
        this.scaledHeight = image.scaledHeight;
        this.rotation = image.rotation;
        this.colorspace = image.colorspace;
        this.rawData = image.rawData;
        this.template = image.template;
        this.bpc = image.bpc;
        this.transparency = image.transparency;
        this.mySerialId = image.mySerialId;
        this.invert = image.invert;
        this.dpiX = image.dpiX;
        this.dpiY = image.dpiY;
        this.mask = image.mask;
        this.imageMask = image.imageMask;
        this.interpolation = image.interpolation;
        this.annotation = image.annotation;
        this.markupAttributes = image.markupAttributes;
        this.profile = image.profile;
        this.deflated = image.deflated;
        this.additional = image.additional;
        this.smask = image.smask;
        this.XYRatio = image.XYRatio;
    }

    public static Image getInstance(Image image) {
        if (image == null) {
            return null;
        }
        try {
            Class<?> clazz = image.getClass();
            Constructor<?> constructor = clazz.getDeclaredConstructor(class$com$lowagie$text$Image == null ? (class$com$lowagie$text$Image = Image.class$("com.lowagie.text.Image")) : class$com$lowagie$text$Image);
            return (Image)constructor.newInstance(image);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(URL uRL) throws BadElementException, MalformedURLException, IOException {
        ImgWMF imgWMF;
        InputStream inputStream;
        block8: {
            Png png;
            block7: {
                Jpeg jpeg;
                block6: {
                    Gif gif;
                    block5: {
                        inputStream = null;
                        try {
                            inputStream = uRL.openStream();
                            int n = inputStream.read();
                            int n2 = inputStream.read();
                            inputStream.close();
                            inputStream = null;
                            if (n == 71 && n2 == 73) {
                                gif = new Gif(uRL);
                                Object var6_8 = null;
                                if (inputStream == null) return gif;
                                break block5;
                            }
                            if (n == 255 && n2 == 216) {
                                jpeg = new Jpeg(uRL);
                                break block6;
                            }
                            if (n == Png.PNGID[0] && n2 == Png.PNGID[1]) {
                                png = new Png(uRL);
                                break block7;
                            }
                            if (n != 215) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                            if (n2 != 205) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                            imgWMF = new ImgWMF(uRL);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            if (inputStream == null) throw throwable;
                            inputStream.close();
                            throw throwable;
                        }
                    }
                    inputStream.close();
                    return gif;
                }
                Object var6_9 = null;
                if (inputStream == null) return jpeg;
                inputStream.close();
                return jpeg;
            }
            Object var6_10 = null;
            if (inputStream == null) return png;
            inputStream.close();
            return png;
        }
        Object var6_11 = null;
        if (inputStream == null) return imgWMF;
        inputStream.close();
        return imgWMF;
    }

    public static Image getInstance(java.awt.Image image, Color color, boolean bl) throws BadElementException, IOException {
        int n;
        int n2;
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("java.awt.Image Interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("java.awt.Image fetch aborted or errored");
        }
        int n3 = pixelGrabber.getWidth();
        int n4 = pixelGrabber.getHeight();
        int[] nArray = (int[])pixelGrabber.getPixels();
        if (bl) {
            int n5 = n3 / 8 + ((n3 & 7) != 0 ? 1 : 0);
            byte[] byArray = new byte[n5 * n4];
            int n6 = 0;
            int n7 = n4 * n3;
            boolean bl2 = true;
            if (color != null) {
                bl2 = color.getRed() + color.getGreen() + color.getBlue() >= 384;
            }
            int[] nArray2 = null;
            int n8 = 128;
            int n9 = 0;
            int n10 = 0;
            if (color != null) {
                int n11 = 0;
                while (n11 < n7) {
                    int n12 = nArray[n11] >> 24 & 0xFF;
                    if (n12 < 250) {
                        if (bl2) {
                            n10 |= n8;
                        }
                    } else if ((nArray[n11] & 0x888) != 0) {
                        n10 |= n8;
                    }
                    if ((n8 >>= 1) == 0 || n9 + 1 >= n3) {
                        byArray[n6++] = (byte)n10;
                        n8 = 128;
                        n10 = 0;
                    }
                    if (++n9 >= n3) {
                        n9 = 0;
                    }
                    ++n11;
                }
            } else {
                int n13 = 0;
                while (n13 < n7) {
                    int n14;
                    if (nArray2 == null && (n14 = nArray[n13] >> 24 & 0xFF) == 0) {
                        nArray2 = new int[2];
                        nArray2[1] = (nArray[n13] & 0x888) != 0 ? 1 : 0;
                        nArray2[0] = nArray2[1];
                    }
                    if ((nArray[n13] & 0x888) != 0) {
                        n10 |= n8;
                    }
                    if ((n8 >>= 1) == 0 || n9 + 1 >= n3) {
                        byArray[n6++] = (byte)n10;
                        n8 = 128;
                        n10 = 0;
                    }
                    if (++n9 >= n3) {
                        n9 = 0;
                    }
                    ++n13;
                }
            }
            return Image.getInstance(n3, n4, 1, 1, byArray, nArray2);
        }
        byte[] byArray = new byte[n3 * n4 * 3];
        byte[] byArray2 = null;
        int n15 = 0;
        int n16 = n4 * n3;
        int n17 = 255;
        int n18 = 255;
        int n19 = 255;
        if (color != null) {
            n17 = color.getRed();
            n18 = color.getGreen();
            n19 = color.getBlue();
        }
        int[] nArray3 = null;
        if (color != null) {
            n2 = 0;
            while (n2 < n16) {
                n = nArray[n2] >> 24 & 0xFF;
                if (n < 250) {
                    byArray[n15++] = (byte)n17;
                    byArray[n15++] = (byte)n18;
                    byArray[n15++] = (byte)n19;
                } else {
                    byArray[n15++] = (byte)(nArray[n2] >> 16 & 0xFF);
                    byArray[n15++] = (byte)(nArray[n2] >> 8 & 0xFF);
                    byArray[n15++] = (byte)(nArray[n2] & 0xFF);
                }
                ++n2;
            }
        } else {
            byArray2 = new byte[n3 * n4];
            n2 = 0;
            n = 0;
            while (n < n16) {
                byArray2[n] = (byte)(nArray[n] >> 24 & 0xFF);
                byte by = byArray2[n];
                if (by != 0 && by != -1) {
                    n2 = 1;
                }
                if (nArray3 == null && by == 0) {
                    nArray3 = new int[6];
                    nArray3[0] = nArray3[1] = nArray[n] >> 16 & 0xFF;
                    nArray3[2] = nArray3[3] = nArray[n] >> 8 & 0xFF;
                    nArray3[4] = nArray3[5] = nArray[n] & 0xFF;
                }
                byArray[n15++] = (byte)(nArray[n] >> 16 & 0xFF);
                byArray[n15++] = (byte)(nArray[n] >> 8 & 0xFF);
                byArray[n15++] = (byte)(nArray[n] & 0xFF);
                ++n;
            }
            if (n2 != 0) {
                nArray3 = null;
            } else {
                byArray2 = null;
            }
        }
        Image image2 = Image.getInstance(n3, n4, 3, 8, byArray, nArray3);
        if (byArray2 != null) {
            Image image3 = Image.getInstance(n3, n4, 1, 8, byArray2);
            try {
                image3.makeMask();
                image2.setImageMask(image3);
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        return image2;
    }

    public static Image getInstance(java.awt.Image image, Color color) throws BadElementException, IOException {
        return Image.getInstance(image, color, false);
    }

    public static Image getInstance(String string) throws BadElementException, MalformedURLException, IOException {
        return Image.getInstance(Image.toURL(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        ImgWMF imgWMF;
        ByteArrayInputStream byteArrayInputStream;
        block8: {
            Png png;
            block7: {
                Jpeg jpeg;
                block6: {
                    Gif gif;
                    block5: {
                        byteArrayInputStream = null;
                        try {
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            int n = ((InputStream)byteArrayInputStream).read();
                            int n2 = ((InputStream)byteArrayInputStream).read();
                            ((InputStream)byteArrayInputStream).close();
                            byteArrayInputStream = null;
                            if (n == 71 && n2 == 73) {
                                gif = new Gif(byArray);
                                Object var6_8 = null;
                                if (byteArrayInputStream == null) return gif;
                                break block5;
                            }
                            if (n == 255 && n2 == 216) {
                                jpeg = new Jpeg(byArray);
                                break block6;
                            }
                            if (n == Png.PNGID[0] && n2 == Png.PNGID[1]) {
                                png = new Png(byArray);
                                break block7;
                            }
                            if (n != 215) throw new IOException("Could not find a recognized imageformat.");
                            if (n2 != 205) throw new IOException("Could not find a recognized imageformat.");
                            imgWMF = new ImgWMF(byArray);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            if (byteArrayInputStream == null) throw throwable;
                            ((InputStream)byteArrayInputStream).close();
                            throw throwable;
                        }
                    }
                    ((InputStream)byteArrayInputStream).close();
                    return gif;
                }
                Object var6_9 = null;
                if (byteArrayInputStream == null) return jpeg;
                ((InputStream)byteArrayInputStream).close();
                return jpeg;
            }
            Object var6_10 = null;
            if (byteArrayInputStream == null) return png;
            ((InputStream)byteArrayInputStream).close();
            return png;
        }
        Object var6_11 = null;
        if (byteArrayInputStream == null) return imgWMF;
        ((InputStream)byteArrayInputStream).close();
        return imgWMF;
    }

    public static Image getInstance(int n, int n2, int n3, int n4, byte[] byArray) throws BadElementException {
        return Image.getInstance(n, n2, n3, n4, byArray, null);
    }

    public static Image getInstance(PdfTemplate pdfTemplate) throws BadElementException {
        return new ImgTemplate(pdfTemplate);
    }

    public static Image getInstance(int n, int n2, boolean bl, int n3, int n4, byte[] byArray) throws BadElementException {
        return Image.getInstance(n, n2, bl, n3, n4, byArray, null);
    }

    public static Image getInstance(int n, int n2, boolean bl, int n3, int n4, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != 2) {
            throw new BadElementException("Transparency length must be equal to 2 with CCITT images");
        }
        ImgCCITT imgCCITT = new ImgCCITT(n, n2, bl, n3, n4, byArray);
        imgCCITT.transparency = nArray;
        return imgCCITT;
    }

    public static Image getInstance(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != n3 * 2) {
            throw new BadElementException("Transparency length must be equal to (componentes * 2)");
        }
        if (n3 == 1 && n4 == 1) {
            byte[] byArray2 = CCITTG4Encoder.compress(byArray, n, n2);
            return Image.getInstance(n, n2, false, 256, 1, byArray2, nArray);
        }
        ImgRaw imgRaw = new ImgRaw(n, n2, n3, n4, byArray);
        imgRaw.transparency = nArray;
        return imgRaw;
    }

    public static Image getInstance(Properties properties) throws BadElementException, MalformedURLException, IOException {
        String string;
        String string2;
        String string3 = (String)((Hashtable)properties).remove("url");
        if (string3 == null) {
            throw new MalformedURLException("The URL of the image is missing.");
        }
        Image image = Image.getInstance(string3);
        int n = 0;
        string3 = (String)((Hashtable)properties).remove("align");
        if (string3 != null) {
            if ("Left".equalsIgnoreCase(string3)) {
                n |= 2;
            } else if ("Right".equalsIgnoreCase(string3)) {
                n |= 1;
            } else if ("Middle".equalsIgnoreCase(string3)) {
                n |= 3;
            }
        }
        if ((string3 = (String)((Hashtable)properties).remove("underlying")) != null && new Boolean(string3).booleanValue()) {
            n |= 8;
        }
        if ((string3 = (String)((Hashtable)properties).remove("textwrap")) != null && new Boolean(string3).booleanValue()) {
            n |= 4;
        }
        image.setAlignment(n);
        string3 = (String)((Hashtable)properties).remove("alt");
        if (string3 != null) {
            image.setAlt(string3);
        }
        if ((string2 = (String)((Hashtable)properties).remove("absolutex")) != null && (string = (String)((Hashtable)properties).remove("absolutey")) != null) {
            image.setAbsolutePosition(Float.valueOf(string2 + "f").floatValue(), Float.valueOf(string + "f").floatValue());
        }
        if ((string3 = (String)((Hashtable)properties).remove("plainwidth")) != null) {
            image.scaleAbsoluteWidth(Float.valueOf(string3 + "f").floatValue());
        }
        if ((string3 = (String)((Hashtable)properties).remove("plainheight")) != null) {
            image.scaleAbsoluteHeight(Float.valueOf(string3 + "f").floatValue());
        }
        if ((string3 = (String)((Hashtable)properties).remove("rotation")) != null) {
            image.setRotation(Float.valueOf(string3 + "f").floatValue());
        }
        if (((Hashtable)properties).size() > 0) {
            image.setMarkupAttributes(properties);
        }
        return image;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public void setAbsolutePosition(float f, float f2) {
        this.absoluteX = f;
        this.absoluteY = f2;
    }

    public void scaleAbsolute(float f, float f2) {
        this.plainWidth = f;
        this.plainHeight = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteWidth(float f) {
        this.plainWidth = f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteHeight(float f) {
        this.plainHeight = f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scalePercent(float f) {
        this.scalePercent(f, f);
    }

    public void scalePercent(float f, float f2) {
        this.plainWidth = this.width() * f / 100.0f;
        this.plainHeight = this.height() * f2 / 100.0f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleToFit(float f, float f2) {
        float f3;
        float f4 = f * 100.0f / this.width();
        this.scalePercent(f4 < (f3 = f2 * 100.0f / this.height()) ? f4 : f3);
    }

    public void setRotation(float f) {
        double d = Math.PI;
        this.rotation = (float)((double)f % (2.0 * d));
        if (this.rotation < 0.0f) {
            this.rotation = (float)((double)this.rotation + 2.0 * d);
        }
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void setRotationDegrees(float f) {
        double d = Math.PI;
        this.setRotation(f / 180.0f * (float)d);
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public Annotation annotation() {
        return this.annotation;
    }

    public int bpc() {
        return this.bpc;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public PdfTemplate templateData() {
        return this.template[0];
    }

    public void setTemplateData(PdfTemplate pdfTemplate) {
        this.template[0] = pdfTemplate;
    }

    public boolean hasAbsolutePosition() {
        return !Float.isNaN(this.absoluteY);
    }

    public boolean hasAbsoluteX() {
        return !Float.isNaN(this.absoluteX);
    }

    public float absoluteX() {
        return this.absoluteX;
    }

    public float absoluteY() {
        return this.absoluteY;
    }

    public int type() {
        return this.type;
    }

    public boolean isGif() {
        return this.type == 31;
    }

    public boolean isJpeg() {
        return this.type == 32;
    }

    public boolean isPng() {
        return this.type == 33;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public boolean isImgTemplate() {
        return this.type == 35;
    }

    public URL url() {
        return this.url;
    }

    public int alignment() {
        return this.alignment;
    }

    public String alt() {
        return this.alt;
    }

    public float scaledWidth() {
        return this.scaledWidth;
    }

    public float scaledHeight() {
        return this.scaledHeight;
    }

    public int colorspace() {
        return this.colorspace;
    }

    public float[] matrix() {
        float[] fArray = new float[8];
        float f = (float)Math.cos(this.rotation);
        float f2 = (float)Math.sin(this.rotation);
        fArray[0] = this.plainWidth * f;
        fArray[1] = this.plainWidth * f2;
        fArray[2] = -this.plainHeight * f2;
        fArray[3] = this.plainHeight * f;
        if ((double)this.rotation < 1.5707963267948966) {
            fArray[4] = fArray[2];
            fArray[5] = 0.0f;
            fArray[6] = fArray[0];
            fArray[7] = fArray[1] + fArray[3];
        } else if ((double)this.rotation < Math.PI) {
            fArray[4] = fArray[0] + fArray[2];
            fArray[5] = fArray[3];
            fArray[6] = 0.0f;
            fArray[7] = fArray[1];
        } else if ((double)this.rotation < 4.71238898038469) {
            fArray[4] = fArray[0];
            fArray[5] = fArray[1] + fArray[3];
            fArray[6] = fArray[2];
            fArray[7] = 0.0f;
        } else {
            fArray[4] = 0.0f;
            fArray[5] = fArray[1];
            fArray[6] = fArray[0] + fArray[2];
            fArray[7] = fArray[3];
        }
        return fArray;
    }

    public static void skip(InputStream inputStream, int n) throws IOException {
        while (n > 0) {
            n = (int)((long)n - inputStream.skip(n));
        }
    }

    public static URL toURL(String string) throws MalformedURLException {
        if (string.startsWith("file:/") || string.startsWith("http://")) {
            return new URL(string);
        }
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        return new URL("file", "", string2);
    }

    public int[] getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int[] nArray) {
        this.transparency = nArray;
    }

    public static boolean isTag(String string) {
        return "image".equals(string);
    }

    public float plainWidth() {
        return this.plainWidth;
    }

    public float plainHeight() {
        return this.plainHeight;
    }

    protected static synchronized Long getSerialId() {
        return new Long(++serialId);
    }

    public Long getMySerialId() {
        return this.mySerialId;
    }

    public int getDpiX() {
        return this.dpiX;
    }

    public int getDpiY() {
        return this.dpiY;
    }

    public void setDpi(int n, int n2) {
        this.dpiX = n;
        this.dpiY = n2;
    }

    public boolean isMaskCandidate() {
        if (this.type == 34 && this.bpc > 255) {
            return true;
        }
        return this.colorspace == 1;
    }

    public void makeMask() throws DocumentException {
        if (!this.isMaskCandidate()) {
            throw new DocumentException("This image can not be an image mask.");
        }
        this.mask = true;
    }

    public void setImageMask(Image image) throws DocumentException {
        if (this.mask) {
            throw new DocumentException("An image mask can not contain another image mask.");
        }
        if (!image.mask) {
            throw new DocumentException("The image mask is not a mask. Did you do makeMask()?");
        }
        this.imageMask = image;
        this.smask = image.bpc > 1 && image.bpc <= 8;
    }

    public Image getImageMask() {
        return this.imageMask;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setInvertMask(boolean bl) {
        this.invert = bl;
    }

    public boolean isInvertMask() {
        return this.invert;
    }

    public boolean isInverted() {
        return this.invert;
    }

    public void setInverted(boolean bl) {
        this.invert = bl;
    }

    public boolean isInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(boolean bl) {
        this.interpolation = bl;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public void tagICC(ICC_Profile iCC_Profile) {
        this.profile = iCC_Profile;
    }

    public boolean hasICCProfile() {
        return this.profile != null;
    }

    public ICC_Profile getICCProfile() {
        return this.profile;
    }

    public boolean isDeflated() {
        return this.deflated;
    }

    public void setDeflated(boolean bl) {
        this.deflated = bl;
    }

    public PdfDictionary getAdditional() {
        return this.additional;
    }

    public void setAdditional(PdfDictionary pdfDictionary) {
        this.additional = pdfDictionary;
    }

    public boolean isSmask() {
        return this.smask;
    }

    public void setSmask(boolean bl) {
        this.smask = bl;
    }

    public float getXYRatio() {
        return this.XYRatio;
    }

    public void setXYRatio(float f) {
        this.XYRatio = f;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

