/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;

public class BarcodeCodabar
extends Barcode {
    static byte[][] BARS = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 1}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 1, 1, 0}};
    static String CHARS = "0123456789-$:/.+ABCD";
    static final int START_STOP_IDX = 16;

    public BarcodeCodabar() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = false;
            this.codeType = 12;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getBarsCodabar(String string) {
        int n = (string = string.toUpperCase()).length();
        if (n < 2) {
            throw new IllegalArgumentException("Codabar must have at least a start and stop character.");
        }
        if (CHARS.indexOf(string.charAt(0)) < 16 || CHARS.indexOf(string.charAt(n - 1)) < 16) {
            throw new IllegalArgumentException("Codabar must have one of 'ABCD' as start/stop character.");
        }
        byte[] byArray = new byte[string.length() * 8 - 1];
        int n2 = 0;
        while (n2 < n) {
            int n3 = CHARS.indexOf(string.charAt(n2));
            if (n3 >= 16 && n2 > 0 && n2 < n - 1) {
                throw new IllegalArgumentException("In codabar, start/stop characters are only allowed at the extremes.");
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(n2) + "' is illegal in codabar.");
            }
            System.arraycopy(BARS[n3], 0, byArray, n2 * 8, 7);
            ++n2;
        }
        return byArray;
    }

    public static String calculateChecksum(String string) {
        if (string.length() < 2) {
            return string;
        }
        String string2 = string.toUpperCase();
        int n = 0;
        int n2 = string2.length();
        int n3 = 0;
        while (n3 < n2) {
            n += CHARS.indexOf(string2.charAt(n3));
            ++n3;
        }
        n = (n + 15) / 16 * 16 - n;
        return string.substring(0, n2 - 1) + CHARS.charAt(n) + string.substring(n2 - 1);
    }

    public Rectangle getBarcodeSize() {
        float f = 0.0f;
        float f2 = 0.0f;
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        if (this.font != null) {
            f2 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            f = this.font.getWidthPoint(string, this.size);
        }
        string = this.code;
        if (this.generateChecksum) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(string);
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        int n3 = byArray.length - n;
        float f3 = this.x * ((float)n3 + (float)n * this.n);
        f3 = Math.max(f3, f);
        float f4 = this.barHeight + f2;
        return new Rectangle(f3, f4);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        float f = 0.0f;
        if (this.font != null) {
            f = this.font.getWidthPoint(string, this.size);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        int n3 = byArray.length - n;
        float f2 = this.x * ((float)n3 + (float)n * this.n);
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f > f2) {
                    f3 = f - f2;
                    break;
                }
                f4 = f2 - f;
                break;
            }
            default: {
                if (f > f2) {
                    f3 = (f - f2) / 2.0f;
                    break;
                }
                f4 = (f2 - f) / 2.0f;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f6 = this.barHeight - this.baseline;
            } else {
                f6 = -this.font.getFontDescriptor(3, this.size);
                f5 = f6 + this.baseline;
            }
        }
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n4 = 0;
        while (n4 < byArray.length) {
            float f7;
            float f8 = f7 = byArray[n4] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f3, f5, f7, this.barHeight);
            }
            bl = !bl;
            f3 += f7;
            ++n4;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f4, f6);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }
}

