/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class Configuration
implements Serializable {
    public static final int RAW = 0;
    public static final int ASCII = 1;
    public static final int LATIN1 = 2;
    public static final int UTF8 = 3;
    public static final int ISO2022 = 4;
    public static final int MACROMAN = 5;
    public static final int DOCTYPE_OMIT = 0;
    public static final int DOCTYPE_AUTO = 1;
    public static final int DOCTYPE_STRICT = 2;
    public static final int DOCTYPE_LOOSE = 3;
    public static final int DOCTYPE_USER = 4;
    protected int spaces = 2;
    protected int wraplen = 68;
    protected int CharEncoding = 1;
    protected int tabsize = 4;
    protected int docTypeMode = 1;
    protected String altText = null;
    protected String slidestyle = null;
    protected String docTypeStr = null;
    protected String errfile = null;
    protected boolean writeback = false;
    protected boolean OnlyErrors = false;
    protected boolean ShowWarnings = true;
    protected boolean Quiet = false;
    protected boolean IndentContent = false;
    protected boolean SmartIndent = false;
    protected boolean HideEndTags = false;
    protected boolean XmlTags = false;
    protected boolean XmlOut = false;
    protected boolean xHTML = false;
    protected boolean XmlPi = false;
    protected boolean RawOut = false;
    protected boolean UpperCaseTags = false;
    protected boolean UpperCaseAttrs = false;
    protected boolean MakeClean = false;
    protected boolean LogicalEmphasis = false;
    protected boolean DropFontTags = false;
    protected boolean DropEmptyParas = true;
    protected boolean FixComments = true;
    protected boolean BreakBeforeBR = false;
    protected boolean BurstSlides = false;
    protected boolean NumEntities = false;
    protected boolean QuoteMarks = false;
    protected boolean QuoteNbsp = true;
    protected boolean QuoteAmpersand = true;
    protected boolean WrapAttVals = false;
    protected boolean WrapScriptlets = false;
    protected boolean WrapSection = true;
    protected boolean WrapAsp = true;
    protected boolean WrapJste = true;
    protected boolean WrapPhp = true;
    protected boolean FixBackslash = true;
    protected boolean IndentAttributes = false;
    protected boolean XmlPIs = false;
    protected boolean XmlSpace = false;
    protected boolean EncloseBodyText = false;
    protected boolean EncloseBlockText = false;
    protected boolean KeepFileTimes = true;
    protected boolean Word2000 = false;
    protected boolean TidyMark = true;
    protected boolean Emacs = false;
    protected boolean LiteralAttribs = false;
    private transient Properties _properties = new Properties();

    public void addProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this._properties.put(string, string2);
        }
        this.parseProps();
    }

    public void parseFile(String string) {
        try {
            this._properties.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            System.err.println(string + iOException.toString());
            return;
        }
        this.parseProps();
    }

    private void parseProps() {
        String string = this._properties.getProperty("indent-spaces");
        if (string != null) {
            this.spaces = Configuration.parseInt(string);
        }
        if ((string = this._properties.getProperty("wrap")) != null) {
            this.wraplen = Configuration.parseInt(string);
        }
        if ((string = this._properties.getProperty("wrap-attributes")) != null) {
            this.WrapAttVals = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("wrap-script-literals")) != null) {
            this.WrapScriptlets = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("wrap-sections")) != null) {
            this.WrapSection = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("wrap-asp")) != null) {
            this.WrapAsp = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("wrap-jste")) != null) {
            this.WrapJste = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("wrap-php")) != null) {
            this.WrapPhp = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("literal-attributes")) != null) {
            this.LiteralAttribs = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("tab-size")) != null) {
            this.tabsize = Configuration.parseInt(string);
        }
        if ((string = this._properties.getProperty("markup")) != null) {
            this.OnlyErrors = Configuration.parseInvBool(string);
        }
        if ((string = this._properties.getProperty("quiet")) != null) {
            this.Quiet = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("tidy-mark")) != null) {
            this.TidyMark = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("indent")) != null) {
            this.IndentContent = this.parseIndent(string);
        }
        if ((string = this._properties.getProperty("indent-attributes")) != null) {
            this.IndentAttributes = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("hide-endtags")) != null) {
            this.HideEndTags = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("input-xml")) != null) {
            this.XmlTags = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("output-xml")) != null) {
            this.XmlOut = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("output-xhtml")) != null) {
            this.xHTML = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("add-xml-pi")) != null) {
            this.XmlPi = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("add-xml-decl")) != null) {
            this.XmlPi = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("assume-xml-procins")) != null) {
            this.XmlPIs = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("raw")) != null) {
            this.RawOut = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("uppercase-tags")) != null) {
            this.UpperCaseTags = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("uppercase-attributes")) != null) {
            this.UpperCaseAttrs = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("clean")) != null) {
            this.MakeClean = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("logical-emphasis")) != null) {
            this.LogicalEmphasis = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("word-2000")) != null) {
            this.Word2000 = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("drop-empty-paras")) != null) {
            this.DropEmptyParas = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("drop-font-tags")) != null) {
            this.DropFontTags = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("enclose-text")) != null) {
            this.EncloseBodyText = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("enclose-block-text")) != null) {
            this.EncloseBlockText = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("alt-text")) != null) {
            this.altText = new String(string);
        }
        if ((string = this._properties.getProperty("add-xml-space")) != null) {
            this.XmlSpace = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("fix-bad-comments")) != null) {
            this.FixComments = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("split")) != null) {
            this.BurstSlides = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("break-before-br")) != null) {
            this.BreakBeforeBR = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("numeric-entities")) != null) {
            this.NumEntities = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("quote-marks")) != null) {
            this.QuoteMarks = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("quote-nbsp")) != null) {
            this.QuoteNbsp = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("quote-ampersand")) != null) {
            this.QuoteAmpersand = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("write-back")) != null) {
            this.writeback = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("keep-time")) != null) {
            this.KeepFileTimes = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("show-warnings")) != null) {
            this.ShowWarnings = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("error-file")) != null) {
            this.errfile = Configuration.parseName(string);
        }
        if ((string = this._properties.getProperty("slide-style")) != null) {
            this.slidestyle = Configuration.parseName(string);
        }
        if ((string = this._properties.getProperty("new-inline-tags")) != null) {
            Configuration.parseInlineTagNames(string);
        }
        if ((string = this._properties.getProperty("new-blocklevel-tags")) != null) {
            Configuration.parseBlockTagNames(string);
        }
        if ((string = this._properties.getProperty("new-empty-tags")) != null) {
            Configuration.parseEmptyTagNames(string);
        }
        if ((string = this._properties.getProperty("new-pre-tags")) != null) {
            Configuration.parsePreTagNames(string);
        }
        if ((string = this._properties.getProperty("char-encoding")) != null) {
            this.CharEncoding = Configuration.parseCharEncoding(string);
        }
        if ((string = this._properties.getProperty("doctype")) != null) {
            this.docTypeStr = this.parseDocType(string);
        }
        if ((string = this._properties.getProperty("fix-backslash")) != null) {
            this.FixBackslash = Configuration.parseBool(string);
        }
        if ((string = this._properties.getProperty("gnu-emacs")) != null) {
            this.Emacs = Configuration.parseBool(string);
        }
    }

    public void adjust() {
        if (this.EncloseBlockText) {
            this.EncloseBodyText = true;
        }
        if (this.SmartIndent) {
            this.IndentContent = true;
        }
        if (this.wraplen == 0) {
            this.wraplen = Integer.MAX_VALUE;
        }
        if (this.Word2000) {
            TagTable.getDefaultTagTable().defineInlineTag("o:p");
        }
        if (this.xHTML) {
            this.XmlOut = true;
            this.UpperCaseTags = false;
            this.UpperCaseAttrs = false;
        }
        if (this.XmlTags) {
            this.XmlOut = true;
            this.XmlPIs = true;
        }
        if (this.XmlOut) {
            this.QuoteAmpersand = true;
            this.HideEndTags = false;
        }
    }

    private static int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Report.badArgument(string);
            n = -1;
        }
        return n;
    }

    private static boolean parseBool(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            if (c == 't' || c == 'T' || c == 'Y' || c == 'y' || c == '1') {
                bl = true;
            } else if (c == 'f' || c == 'F' || c == 'N' || c == 'n' || c == '0') {
                bl = false;
            } else {
                Report.badArgument(string);
            }
        }
        return bl;
    }

    private static boolean parseInvBool(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            if (c == 't' || c == 'T' || c == 'Y' || c == 'y') {
                bl = true;
            } else if (c == 'f' || c == 'F' || c == 'N' || c == 'n') {
                bl = false;
            } else {
                Report.badArgument(string);
            }
        }
        return !bl;
    }

    private static String parseName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        if (stringTokenizer.countTokens() >= 1) {
            string2 = stringTokenizer.nextToken();
        } else {
            Report.badArgument(string);
        }
        return string2;
    }

    private static int parseCharEncoding(String string) {
        int n = 1;
        if (Lexer.wstrcasecmp(string, "ascii") == 0) {
            n = 1;
        } else if (Lexer.wstrcasecmp(string, "latin1") == 0) {
            n = 2;
        } else if (Lexer.wstrcasecmp(string, "raw") == 0) {
            n = 0;
        } else if (Lexer.wstrcasecmp(string, "utf8") == 0) {
            n = 3;
        } else if (Lexer.wstrcasecmp(string, "iso2022") == 0) {
            n = 4;
        } else if (Lexer.wstrcasecmp(string, "mac") == 0) {
            n = 5;
        } else {
            Report.badArgument(string);
        }
        return n;
    }

    private boolean parseIndent(String string) {
        boolean bl = this.IndentContent;
        if (Lexer.wstrcasecmp(string, "yes") == 0) {
            bl = true;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "true") == 0) {
            bl = true;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "no") == 0) {
            bl = false;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "false") == 0) {
            bl = false;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "auto") == 0) {
            bl = true;
            this.SmartIndent = true;
        } else {
            Report.badArgument(string);
        }
        return bl;
    }

    private static void parseInlineTagNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            TagTable.getDefaultTagTable().defineInlineTag(stringTokenizer.nextToken());
        }
    }

    private static void parseBlockTagNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            TagTable.getDefaultTagTable().defineBlockTag(stringTokenizer.nextToken());
        }
    }

    private static void parseEmptyTagNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            TagTable.getDefaultTagTable().defineEmptyTag(stringTokenizer.nextToken());
        }
    }

    private static void parsePreTagNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            TagTable.getDefaultTagTable().definePreTag(stringTokenizer.nextToken());
        }
    }

    protected String parseDocType(String string) {
        if ((string = string.trim()).startsWith("\"")) {
            this.docTypeMode = 4;
            return string;
        }
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        this.docTypeMode = 1;
        if (Lexer.wstrcasecmp(string2, "omit") == 0) {
            this.docTypeMode = 0;
        } else if (Lexer.wstrcasecmp(string2, "strict") == 0) {
            this.docTypeMode = 2;
        } else if (Lexer.wstrcasecmp(string2, "loose") == 0 || Lexer.wstrcasecmp(string2, "transitional") == 0) {
            this.docTypeMode = 3;
        } else {
            Report.badArgument(string);
        }
        return null;
    }
}

