/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.Node;
import org.w3c.tidy.Out;
import org.w3c.tidy.OutImpl;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.TagTable;

public class PPrint {
    public static final short EFFECT_BLEND = -1;
    public static final short EFFECT_BOX_IN = 0;
    public static final short EFFECT_BOX_OUT = 1;
    public static final short EFFECT_CIRCLE_IN = 2;
    public static final short EFFECT_CIRCLE_OUT = 3;
    public static final short EFFECT_WIPE_UP = 4;
    public static final short EFFECT_WIPE_DOWN = 5;
    public static final short EFFECT_WIPE_RIGHT = 6;
    public static final short EFFECT_WIPE_LEFT = 7;
    public static final short EFFECT_VERT_BLINDS = 8;
    public static final short EFFECT_HORZ_BLINDS = 9;
    public static final short EFFECT_CHK_ACROSS = 10;
    public static final short EFFECT_CHK_DOWN = 11;
    public static final short EFFECT_RND_DISSOLVE = 12;
    public static final short EFFECT_SPLIT_VIRT_IN = 13;
    public static final short EFFECT_SPLIT_VIRT_OUT = 14;
    public static final short EFFECT_SPLIT_HORZ_IN = 15;
    public static final short EFFECT_SPLIT_HORZ_OUT = 16;
    public static final short EFFECT_STRIPS_LEFT_DOWN = 17;
    public static final short EFFECT_STRIPS_LEFT_UP = 18;
    public static final short EFFECT_STRIPS_RIGHT_DOWN = 19;
    public static final short EFFECT_STRIPS_RIGHT_UP = 20;
    public static final short EFFECT_RND_BARS_HORZ = 21;
    public static final short EFFECT_RND_BARS_VERT = 22;
    public static final short EFFECT_RANDOM = 23;
    private static final short NORMAL = 0;
    private static final short PREFORMATTED = 1;
    private static final short COMMENT = 2;
    private static final short ATTRIBVALUE = 4;
    private static final short NOWRAP = 8;
    private static final short CDATA = 16;
    private int[] linebuf = null;
    private int lbufsize = 0;
    private int linelen = 0;
    private int wraphere = 0;
    private boolean inAttVal = false;
    private boolean InString = false;
    private int slide = 0;
    private int count = 0;
    private Node slidecontent = null;
    private Configuration configuration;

    public PPrint(Configuration configuration) {
        this.configuration = configuration;
    }

    public static int getUTF8(byte[] byArray, int n, MutableInteger mutableInteger) {
        int n2;
        int n3;
        int n4 = byArray[n] & 0xFF;
        if ((n4 & 0xE0) == 192) {
            n3 = n4 & 0x1F;
            n2 = 2;
        } else if ((n4 & 0xF0) == 224) {
            n3 = n4 & 0xF;
            n2 = 3;
        } else if ((n4 & 0xF8) == 240) {
            n3 = n4 & 7;
            n2 = 4;
        } else if ((n4 & 0xFC) == 248) {
            n3 = n4 & 3;
            n2 = 5;
        } else if ((n4 & 0xFE) == 252) {
            n3 = n4 & 1;
            n2 = 6;
        } else {
            mutableInteger.value = n4;
            return 0;
        }
        for (int i = 1; i < n2; ++i) {
            n4 = byArray[n + i] & 0xFF;
            n3 = n3 << 6 | n4 & 0x3F;
        }
        mutableInteger.value = n3;
        return n2 - 1;
    }

    public static int putUTF8(byte[] byArray, int n, int n2) {
        if (n2 < 128) {
            byArray[n++] = (byte)n2;
        } else if (n2 <= 2047) {
            byArray[n++] = (byte)(0xC0 | n2 >> 6);
            byArray[n++] = (byte)(0x80 | n2 & 0x3F);
        } else if (n2 <= 65535) {
            byArray[n++] = (byte)(0xE0 | n2 >> 12);
            byArray[n++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | n2 & 0x3F);
        } else if (n2 <= 0x1FFFFF) {
            byArray[n++] = (byte)(0xF0 | n2 >> 18);
            byArray[n++] = (byte)(0x80 | n2 >> 12 & 0x3F);
            byArray[n++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | n2 & 0x3F);
        } else {
            byArray[n++] = (byte)(0xF8 | n2 >> 24);
            byArray[n++] = (byte)(0x80 | n2 >> 18 & 0x3F);
            byArray[n++] = (byte)(0x80 | n2 >> 12 & 0x3F);
            byArray[n++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | n2 & 0x3F);
        }
        return n;
    }

    private void addC(int n, int n2) {
        if (n2 + 1 >= this.lbufsize) {
            while (n2 + 1 >= this.lbufsize) {
                if (this.lbufsize == 0) {
                    this.lbufsize = 256;
                    continue;
                }
                this.lbufsize *= 2;
            }
            int[] nArray = new int[this.lbufsize];
            if (this.linebuf != null) {
                System.arraycopy(this.linebuf, 0, nArray, 0, n2);
            }
            this.linebuf = nArray;
        }
        this.linebuf[n2] = n;
    }

    private void wrapLine(Out out, int n) {
        int n2;
        if (this.wraphere == 0) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            out.outc(32);
        }
        for (n2 = 0; n2 < this.wraphere; ++n2) {
            out.outc(this.linebuf[n2]);
        }
        if (this.InString) {
            out.outc(32);
            out.outc(92);
        }
        out.newline();
        if (this.linelen > this.wraphere) {
            int n3 = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int n4 = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[n3] = this.linebuf[n4];
                if (this.linebuf[n4] == 0) break;
                ++n3;
                ++n4;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    private void wrapAttrVal(Out out, int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            out.outc(32);
        }
        for (n2 = 0; n2 < this.wraphere; ++n2) {
            out.outc(this.linebuf[n2]);
        }
        out.outc(32);
        if (bl) {
            out.outc(92);
        }
        out.newline();
        if (this.linelen > this.wraphere) {
            int n3 = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int n4 = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[n3] = this.linebuf[n4];
                if (this.linebuf[n4] == 0) break;
                ++n3;
                ++n4;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    public void flushLine(Out out, int n) {
        if (this.linelen > 0) {
            int n2;
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (!this.inAttVal || this.configuration.IndentAttributes) {
                for (n2 = 0; n2 < n; ++n2) {
                    out.outc(32);
                }
            }
            for (n2 = 0; n2 < this.linelen; ++n2) {
                out.outc(this.linebuf[n2]);
            }
        }
        out.newline();
        this.linelen = 0;
        this.wraphere = 0;
        this.inAttVal = false;
    }

    public void condFlushLine(Out out, int n) {
        if (this.linelen > 0) {
            int n2;
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (!this.inAttVal || this.configuration.IndentAttributes) {
                for (n2 = 0; n2 < n; ++n2) {
                    out.outc(32);
                }
            }
            for (n2 = 0; n2 < this.linelen; ++n2) {
                out.outc(this.linebuf[n2]);
            }
            out.newline();
            this.linelen = 0;
            this.wraphere = 0;
            this.inAttVal = false;
        }
    }

    private void printChar(int n, short s) {
        if (n == 32 && (s & 7) == 0) {
            if ((s & 8) != 0) {
                if (this.configuration.NumEntities || this.configuration.XmlTags) {
                    this.addC(38, this.linelen++);
                    this.addC(35, this.linelen++);
                    this.addC(49, this.linelen++);
                    this.addC(54, this.linelen++);
                    this.addC(48, this.linelen++);
                    this.addC(59, this.linelen++);
                } else {
                    this.addC(38, this.linelen++);
                    this.addC(110, this.linelen++);
                    this.addC(98, this.linelen++);
                    this.addC(115, this.linelen++);
                    this.addC(112, this.linelen++);
                    this.addC(59, this.linelen++);
                }
                return;
            }
            this.wraphere = this.linelen;
        }
        if ((s & 2) != 0) {
            this.addC(n, this.linelen++);
            return;
        }
        if ((s & 0x10) == 0) {
            if (n == 60) {
                this.addC(38, this.linelen++);
                this.addC(108, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n == 62) {
                this.addC(38, this.linelen++);
                this.addC(103, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n == 38 && this.configuration.QuoteAmpersand) {
                this.addC(38, this.linelen++);
                this.addC(97, this.linelen++);
                this.addC(109, this.linelen++);
                this.addC(112, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n == 34 && this.configuration.QuoteMarks) {
                this.addC(38, this.linelen++);
                this.addC(113, this.linelen++);
                this.addC(117, this.linelen++);
                this.addC(111, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n == 39 && this.configuration.QuoteMarks) {
                this.addC(38, this.linelen++);
                this.addC(35, this.linelen++);
                this.addC(51, this.linelen++);
                this.addC(57, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n == 160 && this.configuration.CharEncoding != 0) {
                if (this.configuration.QuoteNbsp) {
                    this.addC(38, this.linelen++);
                    if (this.configuration.NumEntities) {
                        this.addC(35, this.linelen++);
                        this.addC(49, this.linelen++);
                        this.addC(54, this.linelen++);
                        this.addC(48, this.linelen++);
                    } else {
                        this.addC(110, this.linelen++);
                        this.addC(98, this.linelen++);
                        this.addC(115, this.linelen++);
                        this.addC(112, this.linelen++);
                    }
                    this.addC(59, this.linelen++);
                } else {
                    this.addC(n, this.linelen++);
                }
                return;
            }
        }
        if (this.configuration.CharEncoding == 4 || this.configuration.CharEncoding == 0) {
            this.addC(n, this.linelen++);
            return;
        }
        if (n == 160 && (s & 1) != 0) {
            this.addC(32, this.linelen++);
            return;
        }
        if (this.configuration.MakeClean && n >= 8211 && n <= 8222) {
            switch (n) {
                case 8211: 
                case 8212: {
                    n = 45;
                    break;
                }
                case 8216: 
                case 8217: 
                case 8218: {
                    n = 39;
                    break;
                }
                case 8220: 
                case 8221: 
                case 8222: {
                    n = 34;
                }
            }
        }
        if (this.configuration.CharEncoding == 2) {
            if (n > 255) {
                String string;
                string = !this.configuration.NumEntities ? ((string = EntityTable.getDefaultEntityTable().entityName((short)n)) != null ? "&" + string + ";" : "&#" + n + ";") : "&#" + n + ";";
                for (int i = 0; i < string.length(); ++i) {
                    this.addC(string.charAt(i), this.linelen++);
                }
                return;
            }
            if (n > 126 && n < 160) {
                String string = "&#" + n + ";";
                for (int i = 0; i < string.length(); ++i) {
                    this.addC(string.charAt(i), this.linelen++);
                }
                return;
            }
            this.addC(n, this.linelen++);
            return;
        }
        if (this.configuration.CharEncoding == 3) {
            this.addC(n, this.linelen++);
            return;
        }
        if (this.configuration.XmlTags) {
            if (n > 127 && this.configuration.CharEncoding == 1) {
                String string = "&#" + n + ";";
                for (int i = 0; i < string.length(); ++i) {
                    this.addC(string.charAt(i), this.linelen++);
                }
                return;
            }
            this.addC(n, this.linelen++);
            return;
        }
        if (n > 126 || n < 32 && n != 9) {
            String string;
            string = !this.configuration.NumEntities ? ((string = EntityTable.getDefaultEntityTable().entityName((short)n)) != null ? "&" + string + ";" : "&#" + n + ";") : "&#" + n + ";";
            for (int i = 0; i < string.length(); ++i) {
                this.addC(string.charAt(i), this.linelen++);
            }
            return;
        }
        this.addC(n, this.linelen++);
    }

    private void printText(Out out, short s, int n, byte[] byArray, int n2, int n3) {
        MutableInteger mutableInteger = new MutableInteger();
        for (int i = n2; i < n3; ++i) {
            int n4;
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if ((n4 = byArray[i] & 0xFF) > 127) {
                i += PPrint.getUTF8(byArray, i, mutableInteger);
                n4 = mutableInteger.value;
            }
            if (n4 == 10) {
                this.flushLine(out, n);
                continue;
            }
            this.printChar(n4, s);
        }
    }

    private void printString(Out out, int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.addC(string.charAt(i), this.linelen++);
        }
    }

    private void printAttrValue(Out out, int n, String string, int n2, boolean bl) {
        short s;
        MutableInteger mutableInteger = new MutableInteger();
        boolean bl2 = false;
        byte[] byArray = null;
        short s2 = s = bl ? (short)4 : 5;
        if (string != null) {
            byArray = Lexer.getBytes(string);
        }
        if (byArray != null && byArray.length >= 5 && byArray[0] == 60 && (byArray[1] == 37 || byArray[1] == 64 || new String(byArray, 0, 5).equals("<?php"))) {
            s = (short)(s | 0x10);
        }
        if (n2 == 0) {
            n2 = 34;
        }
        this.addC(61, this.linelen++);
        if (!this.configuration.XmlOut) {
            if (n + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            }
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (n + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            } else {
                this.condFlushLine(out, n);
            }
        }
        this.addC(n2, this.linelen++);
        if (string != null) {
            this.InString = false;
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = byArray[n3] & 0xFF;
                if (bl && n4 == 32 && n + this.linelen < this.configuration.wraplen) {
                    this.wraphere = this.linelen;
                    bl2 = this.InString;
                }
                if (bl && this.wraphere > 0 && n + this.linelen >= this.configuration.wraplen) {
                    this.wrapAttrVal(out, n, bl2);
                }
                if (n4 == n2) {
                    String string2 = n4 == 34 ? "&quot;" : "&#39;";
                    for (int i = 0; i < string2.length(); ++i) {
                        this.addC(string2.charAt(i), this.linelen++);
                    }
                    ++n3;
                    continue;
                }
                if (n4 == 34) {
                    if (this.configuration.QuoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(113, this.linelen++);
                        this.addC(117, this.linelen++);
                        this.addC(111, this.linelen++);
                        this.addC(116, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(34, this.linelen++);
                    }
                    if (n2 == 39) {
                        this.InString = !this.InString;
                    }
                    ++n3;
                    continue;
                }
                if (n4 == 39) {
                    if (this.configuration.QuoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(35, this.linelen++);
                        this.addC(51, this.linelen++);
                        this.addC(57, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(39, this.linelen++);
                    }
                    if (n2 == 34) {
                        this.InString = !this.InString;
                    }
                    ++n3;
                    continue;
                }
                if (n4 > 127) {
                    n3 += PPrint.getUTF8(byArray, n3, mutableInteger);
                    n4 = mutableInteger.value;
                }
                ++n3;
                if (n4 == 10) {
                    this.flushLine(out, n);
                    continue;
                }
                this.printChar(n4, s);
            }
        }
        this.InString = false;
        this.addC(n2, this.linelen++);
    }

    private void printAttribute(Out out, int n, Node node, AttVal attVal) {
        boolean bl = false;
        if (this.configuration.IndentAttributes) {
            this.flushLine(out, n);
            n += this.configuration.spaces;
        }
        String string = attVal.attribute;
        if (n + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(out, n);
        }
        if (!this.configuration.XmlTags && !this.configuration.XmlOut && attVal.dict != null) {
            if (AttributeTable.getDefaultAttributeTable().isScript(string)) {
                bl = this.configuration.WrapScriptlets;
            } else if (!attVal.dict.nowrap && this.configuration.WrapAttVals) {
                bl = true;
            }
        }
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
            this.addC(32, this.linelen++);
        } else {
            this.condFlushLine(out, n);
            this.addC(32, this.linelen++);
        }
        for (int i = 0; i < string.length(); ++i) {
            this.addC(Lexer.foldCase(string.charAt(i), this.configuration.UpperCaseAttrs, this.configuration.XmlTags), this.linelen++);
        }
        if (n + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(out, n);
        }
        if (attVal.value == null) {
            if (this.configuration.XmlTags || this.configuration.XmlOut) {
                this.printAttrValue(out, n, attVal.attribute, attVal.delim, true);
            } else if (!attVal.isBoolAttribute() && !Node.isNewNode(node)) {
                this.printAttrValue(out, n, "", attVal.delim, true);
            } else if (n + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            }
        } else {
            this.printAttrValue(out, n, attVal.value, attVal.delim, bl);
        }
    }

    private void printAttrs(Out out, int n, Node node, AttVal attVal) {
        if (attVal != null) {
            if (attVal.next != null) {
                this.printAttrs(out, n, node, attVal.next);
            }
            if (attVal.attribute != null) {
                this.printAttribute(out, n, node, attVal);
            } else if (attVal.asp != null) {
                this.addC(32, this.linelen++);
                this.printAsp(out, n, attVal.asp);
            } else if (attVal.php != null) {
                this.addC(32, this.linelen++);
                this.printPhp(out, n, attVal.php);
            }
        }
        if (this.configuration.XmlOut && this.configuration.XmlSpace && ParserImpl.XMLPreserveWhiteSpace(node) && node.getAttrByName("xml:space") == null) {
            this.printString(out, n, " xml:space=\"preserve\"");
        }
    }

    private static boolean afterSpace(Node node) {
        if (node == null || node.tag == null || (node.tag.model & 0x10) == 0) {
            return true;
        }
        Node node2 = node.prev;
        if (node2 != null) {
            int n;
            return node2.type == 4 && node2.end > node2.start && ((n = node2.textarray[node2.end - 1] & 0xFF) == 160 || n == 32 || n == 10);
        }
        return PPrint.afterSpace(node.parent);
    }

    private void printTag(Lexer lexer, Out out, short s, int n, Node node) {
        this.addC(60, this.linelen++);
        if (node.type == 6) {
            this.addC(47, this.linelen++);
        }
        String string = node.element;
        for (int i = 0; i < string.length(); ++i) {
            this.addC(Lexer.foldCase(string.charAt(i), this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        }
        this.printAttrs(out, n, node, node.attributes);
        if ((this.configuration.XmlOut || lexer != null && lexer.isvoyager) && (node.type == 7 || (node.tag.model & 1) != 0)) {
            this.addC(32, this.linelen++);
            this.addC(47, this.linelen++);
        }
        this.addC(62, this.linelen++);
        if (node.type != 7 && (s & 1) == 0) {
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (n + this.linelen < this.configuration.wraplen) {
                if (PPrint.afterSpace(node) && (s & 8) == 0 && ((node.tag.model & 0x10) == 0 || node.tag == TagTable.tagBr || (node.tag.model & 1) != 0 && node.next == null && node.parent.tag == TagTable.tagA)) {
                    this.wraphere = this.linelen;
                }
            } else {
                this.condFlushLine(out, n);
            }
        }
    }

    private void printEndTag(Out out, short s, int n, Node node) {
        this.addC(60, this.linelen++);
        this.addC(47, this.linelen++);
        String string = node.element;
        for (int i = 0; i < string.length(); ++i) {
            this.addC(Lexer.foldCase(string.charAt(i), this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        }
        this.addC(62, this.linelen++);
    }

    private void printComment(Out out, int n, Node node) {
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.printText(out, (short)2, n, node.textarray, node.start, node.end);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(62, this.linelen++);
        if (node.linebreak) {
            this.flushLine(out, n);
        }
    }

    private void printDocType(Out out, int n, Node node) {
        boolean bl = this.configuration.QuoteMarks;
        this.configuration.QuoteMarks = false;
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.condFlushLine(out, n);
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(79, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(89, this.linelen++);
        this.addC(80, this.linelen++);
        this.addC(69, this.linelen++);
        this.addC(32, this.linelen++);
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.printText(out, (short)0, n, node.textarray, node.start, node.end);
        if (this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(62, this.linelen++);
        this.configuration.QuoteMarks = bl;
        this.condFlushLine(out, n);
    }

    private void printPI(Out out, int n, Node node) {
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(out, (short)16, n, node.textarray, node.start, node.end);
        if (node.textarray[node.end - 1] != 63) {
            this.addC(63, this.linelen++);
        }
        this.addC(62, this.linelen++);
        this.condFlushLine(out, n);
    }

    private void printAsp(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.WrapAsp || !this.configuration.WrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(37, this.linelen++);
        this.printText(out, this.configuration.WrapAsp ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(37, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private void printJste(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.WrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(35, this.linelen++);
        this.printText(out, this.configuration.WrapJste ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(35, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private void printPhp(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.WrapPhp) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(out, this.configuration.WrapPhp ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(63, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private void printCDATA(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        this.condFlushLine(out, n);
        this.configuration.wraplen = 0xFFFFFF;
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(out, (short)2, n, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.condFlushLine(out, n);
        this.configuration.wraplen = n2;
    }

    private void printSection(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.WrapSection) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(out, this.configuration.WrapSection ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private boolean shouldIndent(Node node) {
        if (!this.configuration.IndentContent) {
            return false;
        }
        if (this.configuration.SmartIndent) {
            if (node.content != null && (node.tag.model & 0x40000) != 0) {
                node = node.content;
                while (node != null) {
                    if (node.tag != null && (node.tag.model & 8) != 0) {
                        return true;
                    }
                    node = node.next;
                }
                return false;
            }
            if ((node.tag.model & 0x4000) != 0) {
                return false;
            }
            if (node.tag == TagTable.tagP) {
                return false;
            }
            if (node.tag == TagTable.tagTitle) {
                return false;
            }
        }
        if ((node.tag.model & 0xC00) != 0) {
            return true;
        }
        if (node.tag == TagTable.tagMap) {
            return true;
        }
        return (node.tag.model & 0x10) == 0;
    }

    public void printTree(Out out, short s, int n, Lexer lexer, Node node) {
        if (node == null) {
            return;
        }
        if (node.type == 4) {
            this.printText(out, s, n, node.textarray, node.start, node.end);
        } else if (node.type == 2) {
            this.printComment(out, n, node);
        } else if (node.type == 0) {
            Node node2 = node.content;
            while (node2 != null) {
                this.printTree(out, s, n, lexer, node2);
                node2 = node2.next;
            }
        } else if (node.type == 1) {
            this.printDocType(out, n, node);
        } else if (node.type == 3) {
            this.printPI(out, n, node);
        } else if (node.type == 8) {
            this.printCDATA(out, n, node);
        } else if (node.type == 9) {
            this.printSection(out, n, node);
        } else if (node.type == 10) {
            this.printAsp(out, n, node);
        } else if (node.type == 11) {
            this.printJste(out, n, node);
        } else if (node.type == 12) {
            this.printPhp(out, n, node);
        } else if ((node.tag.model & 1) != 0 || node.type == 7) {
            if ((node.tag.model & 0x10) == 0) {
                this.condFlushLine(out, n);
            }
            if (node.tag == TagTable.tagBr && node.prev != null && node.prev.tag != TagTable.tagBr && this.configuration.BreakBeforeBR) {
                this.flushLine(out, n);
            }
            if (this.configuration.MakeClean && node.tag == TagTable.tagWbr) {
                this.printString(out, n, " ");
            } else {
                this.printTag(lexer, out, s, n, node);
            }
            if (node.tag == TagTable.tagParam || node.tag == TagTable.tagArea) {
                this.condFlushLine(out, n);
            } else if (node.tag == TagTable.tagBr || node.tag == TagTable.tagHr) {
                this.flushLine(out, n);
            }
        } else if (node.tag != null && node.tag.parser == ParserImpl.getParsePre()) {
            this.condFlushLine(out, n);
            n = 0;
            this.condFlushLine(out, n);
            this.printTag(lexer, out, s, n, node);
            this.flushLine(out, n);
            Node node3 = node.content;
            while (node3 != null) {
                this.printTree(out, (short)(s | 1 | 8), n, lexer, node3);
                node3 = node3.next;
            }
            this.condFlushLine(out, n);
            this.printEndTag(out, s, n, node);
            this.flushLine(out, n);
            if (!this.configuration.IndentContent && node.next != null) {
                this.flushLine(out, n);
            }
        } else if (node.tag == TagTable.tagStyle || node.tag == TagTable.tagScript) {
            this.condFlushLine(out, n);
            n = 0;
            this.condFlushLine(out, n);
            this.printTag(lexer, out, s, n, node);
            this.flushLine(out, n);
            Node node4 = node.content;
            while (node4 != null) {
                this.printTree(out, (short)(s | 1 | 8 | 0x10), n, lexer, node4);
                node4 = node4.next;
            }
            this.condFlushLine(out, n);
            this.printEndTag(out, s, n, node);
            this.flushLine(out, n);
            if (!this.configuration.IndentContent && node.next != null) {
                this.flushLine(out, n);
            }
        } else if ((node.tag.model & 0x10) != 0) {
            if (this.configuration.MakeClean) {
                if (node.tag == TagTable.tagFont) {
                    Node node5 = node.content;
                    while (node5 != null) {
                        this.printTree(out, s, n, lexer, node5);
                        node5 = node5.next;
                    }
                    return;
                }
                if (node.tag == TagTable.tagNobr) {
                    Node node6 = node.content;
                    while (node6 != null) {
                        this.printTree(out, (short)(s | 8), n, lexer, node6);
                        node6 = node6.next;
                    }
                    return;
                }
            }
            this.printTag(lexer, out, s, n, node);
            if (this.shouldIndent(node)) {
                this.condFlushLine(out, n);
                n += this.configuration.spaces;
                Node node7 = node.content;
                while (node7 != null) {
                    this.printTree(out, s, n, lexer, node7);
                    node7 = node7.next;
                }
                this.condFlushLine(out, n);
                this.condFlushLine(out, n -= this.configuration.spaces);
            } else {
                Node node8 = node.content;
                while (node8 != null) {
                    this.printTree(out, s, n, lexer, node8);
                    node8 = node8.next;
                }
            }
            this.printEndTag(out, s, n, node);
        } else {
            this.condFlushLine(out, n);
            if (this.configuration.SmartIndent && node.prev != null) {
                this.flushLine(out, n);
            }
            if (!this.configuration.HideEndTags || node.tag == null || (node.tag.model & 0x200000) == 0) {
                this.printTag(lexer, out, s, n, node);
                if (this.shouldIndent(node)) {
                    this.condFlushLine(out, n);
                } else if ((node.tag.model & 2) != 0 || node.tag == TagTable.tagNoframes || (node.tag.model & 4) != 0 && node.tag != TagTable.tagTitle) {
                    this.flushLine(out, n);
                }
            }
            if (node.tag == TagTable.tagBody && this.configuration.BurstSlides) {
                this.printSlide(out, s, this.configuration.IndentContent ? n + this.configuration.spaces : n, lexer);
            } else {
                Node node9 = null;
                Node node10 = node.content;
                while (node10 != null) {
                    if (node9 != null && !this.configuration.IndentContent && node9.type == 4 && node10.tag != null && (node10.tag.model & 8) != 0) {
                        this.flushLine(out, n);
                        this.flushLine(out, n);
                    }
                    this.printTree(out, s, this.shouldIndent(node) ? n + this.configuration.spaces : n, lexer, node10);
                    node9 = node10;
                    node10 = node10.next;
                }
            }
            if (this.shouldIndent(node) || ((node.tag.model & 2) != 0 || node.tag == TagTable.tagNoframes || (node.tag.model & 4) != 0 && node.tag != TagTable.tagTitle) && !this.configuration.HideEndTags) {
                this.condFlushLine(out, this.configuration.IndentContent ? n + this.configuration.spaces : n);
                if (!this.configuration.HideEndTags || (node.tag.model & 0x8000) == 0) {
                    this.printEndTag(out, s, n, node);
                    this.flushLine(out, n);
                }
            } else {
                if (!this.configuration.HideEndTags || (node.tag.model & 0x8000) == 0) {
                    this.printEndTag(out, s, n, node);
                }
                this.flushLine(out, n);
            }
            if (!this.configuration.IndentContent && node.next != null && !this.configuration.HideEndTags && (node.tag.model & 0xE8) != 0) {
                this.flushLine(out, n);
            }
        }
    }

    public void printXMLTree(Out out, short s, int n, Lexer lexer, Node node) {
        if (node == null) {
            return;
        }
        if (node.type == 4) {
            this.printText(out, s, n, node.textarray, node.start, node.end);
        } else if (node.type == 2) {
            this.condFlushLine(out, n);
            this.printComment(out, 0, node);
            this.condFlushLine(out, 0);
        } else if (node.type == 0) {
            Node node2 = node.content;
            while (node2 != null) {
                this.printXMLTree(out, s, n, lexer, node2);
                node2 = node2.next;
            }
        } else if (node.type == 1) {
            this.printDocType(out, n, node);
        } else if (node.type == 3) {
            this.printPI(out, n, node);
        } else if (node.type == 9) {
            this.printSection(out, n, node);
        } else if (node.type == 10) {
            this.printAsp(out, n, node);
        } else if (node.type == 11) {
            this.printJste(out, n, node);
        } else if (node.type == 12) {
            this.printPhp(out, n, node);
        } else if ((node.tag.model & 1) != 0 || node.type == 7) {
            this.condFlushLine(out, n);
            this.printTag(lexer, out, s, n, node);
            this.flushLine(out, n);
            if (node.next != null) {
                this.flushLine(out, n);
            }
        } else {
            int n2;
            boolean bl = false;
            Node node3 = node.content;
            while (node3 != null) {
                if (node3.type == 4) {
                    bl = true;
                    break;
                }
                node3 = node3.next;
            }
            this.condFlushLine(out, n);
            if (ParserImpl.XMLPreserveWhiteSpace(node)) {
                n = 0;
                n2 = 0;
                bl = false;
            } else {
                n2 = bl ? n : n + this.configuration.spaces;
            }
            this.printTag(lexer, out, s, n, node);
            if (!bl) {
                this.flushLine(out, n);
            }
            node3 = node.content;
            while (node3 != null) {
                this.printXMLTree(out, s, n2, lexer, node3);
                node3 = node3.next;
            }
            if (!bl) {
                this.condFlushLine(out, n2);
            }
            this.printEndTag(out, s, n, node);
            this.condFlushLine(out, n);
            if (node.next != null) {
                this.flushLine(out, n);
            }
        }
    }

    public static int countSlides(Node node) {
        int n = 1;
        node = node.content;
        while (node != null) {
            if (node.tag == TagTable.tagH2) {
                ++n;
            }
            node = node.next;
        }
        return n;
    }

    private void printVertSpacer(Out out, int n) {
        this.condFlushLine(out, n);
        this.printString(out, n, "<img width=\"0\" height=\"0\" hspace=\"1\" src=\"dot.gif\" vspace=\"%d\" align=\"left\">");
        this.condFlushLine(out, n);
    }

    private void printNavBar(Out out, int n) {
        String string;
        this.condFlushLine(out, n);
        this.printString(out, n, "<center><small>");
        if (this.slide > 1) {
            string = "<a href=\"slide" + new Integer(this.slide - 1).toString() + ".html\">previous</a> | ";
            this.printString(out, n, string);
            this.condFlushLine(out, n);
            if (this.slide < this.count) {
                this.printString(out, n, "<a href=\"slide1.html\">start</a> | ");
            } else {
                this.printString(out, n, "<a href=\"slide1.html\">start</a>");
            }
            this.condFlushLine(out, n);
        }
        if (this.slide < this.count) {
            string = "<a href=\"slide" + new Integer(this.slide + 1).toString() + ".html\">next</a>";
            this.printString(out, n, string);
        }
        this.printString(out, n, "</small></center>");
        this.condFlushLine(out, n);
    }

    public void printSlide(Out out, short s, int n, Lexer lexer) {
        String string = "<div onclick=\"document.location='slide" + new Integer(this.slide < this.count ? this.slide + 1 : 1).toString() + ".html'\">";
        this.printString(out, n, string);
        this.condFlushLine(out, n);
        if (this.slidecontent.tag == TagTable.tagH2) {
            this.printNavBar(out, n);
            this.addC(60, this.linelen++);
            this.addC(Lexer.foldCase('h', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            this.addC(Lexer.foldCase('r', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            if (this.configuration.XmlOut) {
                this.printString(out, n, " />");
            } else {
                this.addC(62, this.linelen++);
            }
            if (this.configuration.IndentContent) {
                this.condFlushLine(out, n);
            }
            this.printTree(out, s, this.configuration.IndentContent ? n + this.configuration.spaces : n, lexer, this.slidecontent);
            this.slidecontent = this.slidecontent.next;
        }
        Node node = null;
        Node node2 = this.slidecontent;
        while (node2 != null && node2.tag != TagTable.tagH2) {
            if (node != null && !this.configuration.IndentContent && node.type == 4 && node2.tag != null && (node2.tag.model & 8) != 0) {
                this.flushLine(out, n);
                this.flushLine(out, n);
            }
            this.printTree(out, s, this.configuration.IndentContent ? n + this.configuration.spaces : n, lexer, node2);
            node = node2;
            node2 = node2.next;
        }
        this.slidecontent = node2;
        this.condFlushLine(out, n);
        this.printString(out, n, "<br clear=\"all\">");
        this.condFlushLine(out, n);
        this.addC(60, this.linelen++);
        this.addC(Lexer.foldCase('h', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        this.addC(Lexer.foldCase('r', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        if (this.configuration.XmlOut) {
            this.printString(out, n, " />");
        } else {
            this.addC(62, this.linelen++);
        }
        if (this.configuration.IndentContent) {
            this.condFlushLine(out, n);
        }
        this.printNavBar(out, n);
        this.printString(out, n, "</div>");
        this.condFlushLine(out, n);
    }

    public void addTransitionEffect(Lexer lexer, Node node, short s, double d) {
        Node node2 = Node.findHead(node);
        String string = 0 <= s && s <= 23 ? "revealTrans(Duration=" + new Double(d).toString() + ",Transition=" + s + ")" : "blendTrans(Duration=" + new Double(d).toString() + ")";
        if (node2 != null) {
            Node node3 = lexer.inferredTag("meta");
            node3.addAttribute("http-equiv", "Page-Enter");
            node3.addAttribute("content", string);
            Node.insertNodeAtStart(node2, node3);
        }
    }

    public void createSlides(Lexer lexer, Node node) {
        String string;
        OutImpl outImpl = new OutImpl();
        Node node2 = Node.findBody(node);
        this.count = PPrint.countSlides(node2);
        this.slidecontent = node2.content;
        this.addTransitionEffect(lexer, node, (short)-1, 3.0);
        this.slide = 1;
        while (this.slide <= this.count) {
            string = "slide" + this.slide + ".html";
            outImpl.state = 0;
            outImpl.encoding = this.configuration.CharEncoding;
            try {
                outImpl.out = new FileOutputStream(string);
                this.printTree(outImpl, (short)0, 0, lexer, node);
                this.flushLine(outImpl, 0);
                outImpl.out.close();
            }
            catch (IOException iOException) {
                System.err.println(string + iOException.toString());
            }
            ++this.slide;
        }
        while (new File(string = "slide" + this.slide + "html").delete()) {
            ++this.slide;
        }
    }
}

