/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class ParserImpl {
    private static Parser _parseHTML = new ParseHTML();
    private static Parser _parseHead = new ParseHead();
    private static Parser _parseTitle = new ParseTitle();
    private static Parser _parseScript = new ParseScript();
    private static Parser _parseBody = new ParseBody();
    private static Parser _parseFrameSet = new ParseFrameSet();
    private static Parser _parseInline = new ParseInline();
    private static Parser _parseList = new ParseList();
    private static Parser _parseDefList = new ParseDefList();
    private static Parser _parsePre = new ParsePre();
    private static Parser _parseBlock = new ParseBlock();
    private static Parser _parseTableTag = new ParseTableTag();
    private static Parser _parseColGroup = new ParseColGroup();
    private static Parser _parseRowGroup = new ParseRowGroup();
    private static Parser _parseRow = new ParseRow();
    private static Parser _parseNoFrames = new ParseNoFrames();
    private static Parser _parseSelect = new ParseSelect();
    private static Parser _parseText = new ParseText();
    private static Parser _parseOptGroup = new ParseOptGroup();

    private static void parseTag(Lexer lexer, Node node, short s) {
        if ((node.tag.model & 1) != 0) {
            lexer.waswhite = false;
            return;
        }
        if ((node.tag.model & 0x10) == 0) {
            lexer.insertspace = false;
        }
        if (node.tag.parser == null || node.type == 7) {
            return;
        }
        node.tag.parser.parse(lexer, node, s);
    }

    private static void moveToHead(Lexer lexer, Node node, Node node2) {
        if (node2.type == 5 || node2.type == 7) {
            Report.warning(lexer, node, node2, (short)6);
            while (node.tag != TagTable.tagHtml) {
                node = node.parent;
            }
            Node node3 = node.content;
            while (node3 != null) {
                if (node3.tag == TagTable.tagHead) {
                    Node.insertNodeAtEnd(node3, node2);
                    break;
                }
                node3 = node3.next;
            }
            if (node2.tag.parser != null) {
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
        } else {
            Report.warning(lexer, node, node2, (short)3);
        }
    }

    public static Parser getParseHTML() {
        return _parseHTML;
    }

    public static Parser getParseHead() {
        return _parseHead;
    }

    public static Parser getParseTitle() {
        return _parseTitle;
    }

    public static Parser getParseScript() {
        return _parseScript;
    }

    public static Parser getParseBody() {
        return _parseBody;
    }

    public static Parser getParseFrameSet() {
        return _parseFrameSet;
    }

    public static Parser getParseInline() {
        return _parseInline;
    }

    public static Parser getParseList() {
        return _parseList;
    }

    public static Parser getParseDefList() {
        return _parseDefList;
    }

    public static Parser getParsePre() {
        return _parsePre;
    }

    public static Parser getParseBlock() {
        return _parseBlock;
    }

    public static Parser getParseTableTag() {
        return _parseTableTag;
    }

    public static Parser getParseColGroup() {
        return _parseColGroup;
    }

    public static Parser getParseRowGroup() {
        return _parseRowGroup;
    }

    public static Parser getParseRow() {
        return _parseRow;
    }

    public static Parser getParseNoFrames() {
        return _parseNoFrames;
    }

    public static Parser getParseSelect() {
        return _parseSelect;
    }

    public static Parser getParseText() {
        return _parseText;
    }

    public static Parser getParseOptGroup() {
        return _parseOptGroup;
    }

    public static Node parseDocument(Lexer lexer) {
        Node node;
        Node node2 = null;
        Node node3 = lexer.newNode();
        node3.type = 0;
        while ((node = lexer.getToken((short)0)) != null) {
            Node node4;
            if (Node.insertMisc(node3, node)) continue;
            if (node.type == 1) {
                if (node2 == null) {
                    Node.insertNodeAtEnd(node3, node);
                    node2 = node;
                    continue;
                }
                Report.warning(lexer, node3, node, (short)3);
                continue;
            }
            if (node.type == 6) {
                Report.warning(lexer, node3, node, (short)3);
                continue;
            }
            if (node.type != 5 || node.tag != TagTable.tagHtml) {
                lexer.ungetToken();
                node4 = lexer.inferredTag("html");
            } else {
                node4 = node;
            }
            Node.insertNodeAtEnd(node3, node4);
            ParserImpl.getParseHTML().parse(lexer, node4, (short)0);
            break;
        }
        return node3;
    }

    public static boolean XMLPreserveWhiteSpace(Node node) {
        AttVal attVal = node.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("xml:space")) {
                return attVal.value.equals("preserve");
            }
            attVal = attVal.next;
        }
        if (Lexer.wstrcasecmp(node.element, "pre") == 0 || Lexer.wstrcasecmp(node.element, "script") == 0 || Lexer.wstrcasecmp(node.element, "style") == 0 || TagTable.getDefaultTagTable().findParser(node) == ParserImpl.getParsePre()) {
            return true;
        }
        return Lexer.wstrcasecmp(node.element, "xsl:text") == 0;
    }

    public static void parseXMLElement(Lexer lexer, Node node, short s) {
        Node node2;
        if (Lexer.wstrcasecmp(node.element, "xsl:text") == 0) {
            return;
        }
        if (ParserImpl.XMLPreserveWhiteSpace(node)) {
            s = (short)2;
        }
        while ((node2 = lexer.getToken(s)) != null) {
            if (node2.type == 6 && node2.element.equals(node.element)) {
                node.closed = true;
                break;
            }
            if (node2.type == 6) {
                Report.error(lexer, node, node2, (short)8);
                continue;
            }
            if (node2.type == 5) {
                ParserImpl.parseXMLElement(lexer, node2, s);
            }
            Node.insertNodeAtEnd(node, node2);
        }
        if ((node2 = node.content) != null && node2.type == 4 && s != 2 && node2.textarray[node2.start] == 32) {
            ++node2.start;
            if (node2.start >= node2.end) {
                Node.discardElement(node2);
            }
        }
        if ((node2 = node.last) != null && node2.type == 4 && s != 2 && node2.textarray[node2.end - 1] == 32) {
            --node2.end;
            if (node2.start >= node2.end) {
                Node.discardElement(node2);
            }
        }
    }

    public static Node parseXMLDocument(Lexer lexer) {
        Node node;
        Node node2 = lexer.newNode();
        node2.type = 0;
        Node node3 = null;
        lexer.configuration.XmlTags = true;
        while ((node = lexer.getToken((short)0)) != null) {
            if (node.type == 6) {
                Report.warning(lexer, null, node, (short)8);
                continue;
            }
            if (Node.insertMisc(node2, node)) continue;
            if (node.type == 1) {
                if (node3 == null) {
                    Node.insertNodeAtEnd(node2, node);
                    node3 = node;
                    continue;
                }
                Report.warning(lexer, node2, node, (short)3);
                continue;
            }
            if (node.type != 5) continue;
            Node.insertNodeAtEnd(node2, node);
            ParserImpl.parseXMLElement(lexer, node, (short)0);
        }
        if (node3 != null && !lexer.checkDocTypeKeyWords(node3)) {
            Report.warning(lexer, node3, null, (short)32);
        }
        if (lexer.configuration.XmlPi) {
            lexer.fixXMLPI(node2);
        }
        return node2;
    }

    public static boolean isJavaScript(Node node) {
        boolean bl = false;
        if (node.attributes == null) {
            return true;
        }
        AttVal attVal = node.attributes;
        while (attVal != null) {
            if ((Lexer.wstrcasecmp(attVal.attribute, "language") == 0 || Lexer.wstrcasecmp(attVal.attribute, "type") == 0) && Lexer.wsubstr(attVal.value, "javascript")) {
                bl = true;
            }
            attVal = attVal.next;
        }
        return bl;
    }

    public static class ParseOptGroup
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 5 && (node2.tag == TagTable.tagOption || node2.tag == TagTable.tagOptgroup)) {
                    if (node2.tag == TagTable.tagOptgroup) {
                        Report.warning(lexer, node, node2, (short)14);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, (short)1);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
        }
    }

    public static class ParseText
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            lexer.insert = -1;
            if (node.tag == TagTable.tagTextarea) {
                s = (short)2;
            }
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 4) {
                    if (node.content == null && (s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    if (node2.start >= node2.end) continue;
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (node2.tag == TagTable.tagFont) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if ((node.tag.model & 0x8000) == 0) {
                    Report.warning(lexer, node, node2, (short)2);
                }
                lexer.ungetToken();
                Node.trimSpaces(lexer, node);
                return;
            }
            if ((node.tag.model & 0x8000) == 0) {
                Report.warning(lexer, node, node2, (short)1);
            }
        }
    }

    public static class ParseSelect
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 5 && (node2.tag == TagTable.tagOption || node2.tag == TagTable.tagOptgroup || node2.tag == TagTable.tagScript)) {
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            Report.warning(lexer, node, node2, (short)1);
        }
    }

    public static class ParseNoFrames
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            lexer.badAccess = (short)(lexer.badAccess | 0x20);
            s = 0;
            boolean bl = true;
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (node2.tag == TagTable.tagFrame || node2.tag == TagTable.tagFrameset) {
                    Report.warning(lexer, node, node2, (short)2);
                    Node.trimSpaces(lexer, node);
                    lexer.ungetToken();
                    return;
                }
                if (node2.tag == TagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == TagTable.tagBody && node2.type == 5) {
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                if (node2.type == 4 || node2.tag != null) {
                    lexer.ungetToken();
                    node2 = lexer.inferredTag("body");
                    if (lexer.configuration.XmlOut) {
                        Report.warning(lexer, node, node2, (short)10);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            Report.warning(lexer, node, node2, (short)1);
        }
    }

    public static class ParseRow
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag) {
                    if (node2.type == 6) {
                        node.closed = true;
                        Node.fixEmptyRow(lexer, node);
                        return;
                    }
                    lexer.ungetToken();
                    Node.fixEmptyRow(lexer, node);
                    return;
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag == TagTable.tagTd || node2.tag == TagTable.tagTh) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == TagTable.tagTable) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != null && (node2.tag.model & 0x100) != 0) {
                    lexer.ungetToken();
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 6) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("td");
                        Report.warning(lexer, node, node2, (short)7);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(node, node2);
                            Report.warning(lexer, node, node2, (short)6);
                            lexer.exiled = true;
                            if (node2.type != 4) {
                                ParserImpl.parseTag(lexer, node2, (short)0);
                            }
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            Report.warning(lexer, node, node2, (short)6);
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.tag != TagTable.tagTd && node2.tag != TagTable.tagTh) {
                    Report.warning(lexer, node, node2, (short)6);
                    continue;
                }
                Node.insertNodeAtEnd(node, node2);
                boolean bl = lexer.excludeBlocks;
                lexer.excludeBlocks = false;
                ParserImpl.parseTag(lexer, node2, (short)0);
                lexer.excludeBlocks = bl;
                while (lexer.istack.size() > lexer.istackbase) {
                    lexer.popInline(null);
                }
            }
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseRowGroup
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag) {
                    if (node2.type == 6) {
                        node.closed = true;
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    lexer.ungetToken();
                    return;
                }
                if (node2.tag == TagTable.tagTable && node2.type == 6) {
                    lexer.ungetToken();
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == TagTable.tagTd || node2.tag == TagTable.tagTh) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("tr");
                        Report.warning(lexer, node, node2, (short)7);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(node, node2);
                            Report.warning(lexer, node, node2, (short)6);
                            lexer.exiled = true;
                            if (node2.type != 4) {
                                ParserImpl.parseTag(lexer, node2, (short)0);
                            }
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            Report.warning(lexer, node, node2, (short)6);
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag == TagTable.tagTr || node2.tag == TagTable.tagTd || node2.tag == TagTable.tagTh) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x100) != 0) {
                    if (node2.type != 6) {
                        lexer.ungetToken();
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 6) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != TagTable.tagTr) {
                    node2 = lexer.inferredTag("tr");
                    Report.warning(lexer, node, node2, (short)7);
                    lexer.ungetToken();
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseColGroup
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    return;
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.ungetToken();
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (node2.type == 4) {
                    lexer.ungetToken();
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != TagTable.tagCol) {
                    lexer.ungetToken();
                    return;
                }
                if (node2.type == 6) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
        }
    }

    public static class ParseTableTag
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            lexer.deferDup();
            int n = lexer.istackbase;
            lexer.istackbase = lexer.istack.size();
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    lexer.istackbase = n;
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == TagTable.tagTd || node2.tag == TagTable.tagTh || node2.tag == TagTable.tagTable) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("tr");
                        Report.warning(lexer, node, node2, (short)7);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.insertNodeBeforeElement(node, node2);
                            Report.warning(lexer, node, node2, (short)6);
                            lexer.exiled = true;
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag != null && (node2.tag.model & 0x280) != 0) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer, node, node2, (short)2);
                            lexer.ungetToken();
                            lexer.istackbase = n;
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x80) == 0) {
                    lexer.ungetToken();
                    Report.warning(lexer, node, node2, (short)6);
                    lexer.istackbase = n;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 5 || node2.type == 7) {
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            Report.warning(lexer, node, node2, (short)1);
            Node.trimEmptyElement(lexer, node);
            lexer.istackbase = n;
        }
    }

    public static class ParseBlock
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            int n = 0;
            boolean bl = true;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if (node.tag == TagTable.tagForm && node.isDescendantOf(TagTable.tagForm)) {
                Report.warning(lexer, node, null, (short)20);
            }
            if ((node.tag.model & 0x800) != 0) {
                n = lexer.istackbase;
                lexer.istackbase = lexer.istack.size();
            }
            if ((node.tag.model & 0x20000) == 0) {
                lexer.inlineDup(null);
            }
            s = 0;
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.type == 6 && node2.tag != null && (node2.tag == node.tag || node.was == node2.tag)) {
                    if ((node.tag.model & 0x800) != 0) {
                        while (lexer.istack.size() > lexer.istackbase) {
                            lexer.popInline(null);
                        }
                        lexer.istackbase = n;
                    }
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == TagTable.tagHtml || node2.tag == TagTable.tagHead || node2.tag == TagTable.tagBody) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == null) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag == TagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == TagTable.tagP) {
                        Node.coerceNode(lexer, node2, TagTable.tagBr);
                        Node.insertNodeAtEnd(node, node2);
                        node2 = lexer.inferredTag("br");
                    } else {
                        Node node3 = node.parent;
                        while (node3 != null) {
                            if (node2.tag == node3.tag) {
                                if ((node.tag.model & 0x8000) == 0) {
                                    Report.warning(lexer, node, node2, (short)2);
                                }
                                lexer.ungetToken();
                                if ((node.tag.model & 0x800) != 0) {
                                    while (lexer.istack.size() > lexer.istackbase) {
                                        lexer.popInline(null);
                                    }
                                    lexer.istackbase = n;
                                }
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            node3 = node3.parent;
                        }
                        if (lexer.exiled && node2.tag.model != 0 && (node2.tag.model & 0x80) != 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    }
                }
                if (node2.type == 4) {
                    boolean bl2 = false;
                    if (node2.type == 4 && node2.end <= node2.start + 1 && lexer.lexbuf[node2.start] == 32) {
                        bl2 = true;
                    }
                    if (lexer.configuration.EncloseBlockText && !bl2) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("p");
                        Node.insertNodeAtEnd(node, node2);
                        ParserImpl.parseTag(lexer, node2, (short)1);
                        continue;
                    }
                    if (bl) {
                        bl = false;
                        if ((node.tag.model & 0x20000) == 0 && lexer.inlineDup(node2) > 0) continue;
                    }
                    Node.insertNodeAtEnd(node, node2);
                    s = 1;
                    lexer.versions = (short)(lexer.versions & 0xFFFFFFFB);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == TagTable.tagParam) {
                    if ((node.tag.model & 0x1000) != 0 && (node2.type == 5 || node2.type == 7)) {
                        Node.insertNodeAtEnd(node, node2);
                        continue;
                    }
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == TagTable.tagArea) {
                    if (node.tag == TagTable.tagMap && (node2.type == 5 || node2.type == 7)) {
                        Node.insertNodeAtEnd(node, node2);
                        continue;
                    }
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == null) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5 && node2.type != 7) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if (node.tag == TagTable.tagTd || node.tag == TagTable.tagTh) {
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                        if ((node2.tag.model & 0x20) != 0) {
                            lexer.ungetToken();
                            node2 = lexer.inferredTag("ul");
                            Node.addClass(node2, "noindent");
                            lexer.excludeBlocks = true;
                        } else if ((node2.tag.model & 0x40) != 0) {
                            lexer.ungetToken();
                            node2 = lexer.inferredTag("dl");
                            lexer.excludeBlocks = true;
                        }
                        if ((node2.tag.model & 8) == 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    } else if ((node2.tag.model & 8) != 0) {
                        if (lexer.excludeBlocks) {
                            if ((node.tag.model & 0x8000) == 0) {
                                Report.warning(lexer, node, node2, (short)2);
                            }
                            lexer.ungetToken();
                            if ((node.tag.model & 0x800) != 0) {
                                lexer.istackbase = n;
                            }
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    } else {
                        if ((node.tag.model & 0x8000) == 0 && !node.implicit) {
                            Report.warning(lexer, node, node2, (short)2);
                        }
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                        lexer.ungetToken();
                        if ((node2.tag.model & 0x20) != 0) {
                            if (node.parent != null && node.parent.tag != null && node.parent.tag.parser == ParserImpl.getParseList()) {
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            node2 = lexer.inferredTag("ul");
                            Node.addClass(node2, "noindent");
                        } else if ((node2.tag.model & 0x40) != 0) {
                            if (node.parent.tag == TagTable.tagDl) {
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            node2 = lexer.inferredTag("dl");
                        } else if ((node2.tag.model & 0x80) != 0 || (node2.tag.model & 0x200) != 0) {
                            node2 = lexer.inferredTag("table");
                        } else {
                            if ((node.tag.model & 0x800) != 0) {
                                while (lexer.istack.size() > lexer.istackbase) {
                                    lexer.popInline(null);
                                }
                                lexer.istackbase = n;
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    }
                }
                if (node2.type == 5 || node2.type == 7) {
                    if ((node2.tag.model & 0x10) != 0) {
                        if (bl && !node2.implicit) {
                            bl = false;
                            if (lexer.inlineDup(node2) > 0) continue;
                        }
                        s = 1;
                    } else {
                        bl = true;
                        s = 0;
                    }
                    if (node2.tag == TagTable.tagBr) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    if (node2.implicit) {
                        Report.warning(lexer, node, node2, (short)10);
                    }
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                if (node2.type == 6) {
                    lexer.popInline(node2);
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            if ((node.tag.model & 0x8000) == 0) {
                Report.warning(lexer, node, node2, (short)1);
            }
            if ((node.tag.model & 0x800) != 0) {
                while (lexer.istack.size() > lexer.istackbase) {
                    lexer.popInline(null);
                }
                lexer.istackbase = n;
            }
            Node.trimSpaces(lexer, node);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParsePre
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if ((node.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer, node, TagTable.tagPre);
            }
            lexer.inlineDup(null);
            while ((node2 = lexer.getToken((short)2)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    Node.trimSpaces(lexer, node);
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == TagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 4) {
                    if (node.content == null) {
                        if (node2.textarray[node2.start] == 10) {
                            ++node2.start;
                        }
                        if (node2.start >= node2.end) continue;
                    }
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null || node2.tag == TagTable.tagParam) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == TagTable.tagP) {
                    if (node2.type == 5) {
                        Report.warning(lexer, node, node2, (short)9);
                        Node.trimSpaces(lexer, node);
                        Node.coerceNode(lexer, node2, TagTable.tagBr);
                        Node.insertNodeAtEnd(node, node2);
                        continue;
                    }
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if ((node2.tag.model & 4) != 0 && (node2.tag.model & 8) == 0) {
                    ParserImpl.moveToHead(lexer, node, node2);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer, node, node2, (short)2);
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Report.warning(lexer, node, node2, (short)2);
                    lexer.excludeBlocks = true;
                    if ((node2.tag.model & 0x20) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("ul");
                        Node.addClass(node2, "noindent");
                    } else if ((node2.tag.model & 0x40) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("dl");
                    } else if ((node2.tag.model & 0x80) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("table");
                    }
                    Node.insertNodeAfterElement(node, node2);
                    node = lexer.inferredTag("pre");
                    Node.insertNodeAfterElement(node2, node);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    lexer.excludeBlocks = false;
                    continue;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.tag == TagTable.tagBr) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, (short)2);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            Report.warning(lexer, node, node2, (short)1);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseDefList
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 4) {
                    lexer.ungetToken();
                    node2 = lexer.inferredTag("dt");
                    Report.warning(lexer, node, node2, (short)7);
                }
                if (node2.tag == null) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer, node, node2, (short)2);
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (node2.tag == TagTable.tagCenter) {
                    if (node.content != null) {
                        Node.insertNodeAfterElement(node, node2);
                    } else {
                        Node.insertNodeBeforeElement(node, node2);
                        Node.discardElement(node);
                    }
                    ParserImpl.parseTag(lexer, node2, s);
                    node = lexer.inferredTag("dl");
                    Node.insertNodeAfterElement(node2, node);
                    continue;
                }
                if (node2.tag != TagTable.tagDt && node2.tag != TagTable.tagDd) {
                    lexer.ungetToken();
                    if ((node2.tag.model & 0x18) == 0) {
                        Report.warning(lexer, node, node2, (short)6);
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    if ((node2.tag.model & 0x10) == 0 && lexer.excludeBlocks) {
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    node2 = lexer.inferredTag("dd");
                    Report.warning(lexer, node, node2, (short)7);
                }
                if (node2.type == 6) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
            Report.warning(lexer, node, node2, (short)1);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseList
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    if ((node.tag.model & 0x80000) != 0) {
                        Node.coerceNode(lexer, node, TagTable.tagUl);
                    }
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type != 4 && node2.tag == null) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag != null && (node2.tag.model & 0x10) != 0) {
                        Report.warning(lexer, node, node2, (short)3);
                        lexer.popInline(node2);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer, node, node2, (short)2);
                            lexer.ungetToken();
                            if ((node.tag.model & 0x80000) != 0) {
                                Node.coerceNode(lexer, node, TagTable.tagUl);
                            }
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != TagTable.tagLi) {
                    lexer.ungetToken();
                    if (node2.tag != null && (node2.tag.model & 8) != 0 && lexer.excludeBlocks) {
                        Report.warning(lexer, node, node2, (short)2);
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    node2 = lexer.inferredTag("li");
                    node2.addAttribute("style", "list-style: none");
                    Report.warning(lexer, node, node2, (short)7);
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
            if ((node.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer, node, TagTable.tagUl);
            }
            Report.warning(lexer, node, node2, (short)1);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseInline
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if (node.tag == TagTable.tagA && node.attributes == null) {
                Report.warning(lexer, node.parent, node, (short)3);
                Node.discardElement(node);
                return;
            }
            if ((node.tag.model & 8) != 0 || node.tag == TagTable.tagDt) {
                lexer.inlineDup(null);
            } else if ((node.tag.model & 0x10) != 0 && node.tag != TagTable.tagA && node.tag != TagTable.tagSpan) {
                lexer.pushInline(node);
            }
            if (node.tag == TagTable.tagNobr) {
                lexer.badLayout = (short)(lexer.badLayout | 4);
            } else if (node.tag == TagTable.tagFont) {
                lexer.badLayout = (short)(lexer.badLayout | 8);
            }
            if (s != 2) {
                s = 1;
            }
            while ((node2 = lexer.getToken(s)) != null) {
                Node node3;
                if (node2.tag == node.tag && node2.type == 6) {
                    if ((node.tag.model & 0x10) != 0 && node.tag != TagTable.tagA) {
                        lexer.popInline(node2);
                    }
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    if (node.tag == TagTable.tagFont && node.content != null && node.content == node.last) {
                        node3 = node.content;
                        if (node3.tag == TagTable.tagA) {
                            node3.parent = node.parent;
                            node3.next = node.next;
                            node3.prev = node.prev;
                            if (node3.prev != null) {
                                node3.prev.next = node3;
                            } else {
                                node3.parent.content = node3;
                            }
                            if (node3.next != null) {
                                node3.next.prev = node3;
                            } else {
                                node3.parent.last = node3;
                            }
                            node.next = null;
                            node.prev = null;
                            node.parent = node3;
                            node.content = node3.content;
                            node.last = node3.last;
                            node3.content = node;
                            node3.last = node;
                            node3 = node.content;
                            while (node3 != null) {
                                node3.parent = node;
                                node3 = node3.next;
                            }
                        }
                    }
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 5 && node2.tag == node.tag && lexer.isPushed(node2) && !node2.implicit && !node.implicit && node2.tag != null && (node2.tag.model & 0x10) != 0 && node2.tag != TagTable.tagA && node2.tag != TagTable.tagFont && node2.tag != TagTable.tagBig && node2.tag != TagTable.tagSmall) {
                    if (node.content != null && node2.attributes == null) {
                        Report.warning(lexer, node, node2, (short)19);
                        node2.type = (short)6;
                        lexer.ungetToken();
                        continue;
                    }
                    Report.warning(lexer, node, node2, (short)4);
                }
                if (node2.type == 4) {
                    if (node.content == null && (s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    if (node2.start >= node2.end) continue;
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == TagTable.tagHtml) {
                    if (node2.type == 5 || node2.type == 7) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    lexer.ungetToken();
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == TagTable.tagP && node2.type == 5 && ((s & 2) != 0 || node.tag == TagTable.tagDt || node.isDescendantOf(TagTable.tagDt))) {
                    node2.tag = TagTable.tagBr;
                    node2.element = new String("br");
                    Node.trimSpaces(lexer, node);
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (node2.tag == null || node2.tag == TagTable.tagParam) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == TagTable.tagBr && node2.type == 6) {
                    node2.type = (short)5;
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == TagTable.tagP) {
                        if (!node.isDescendantOf(TagTable.tagP)) {
                            Node.coerceNode(lexer, node2, TagTable.tagBr);
                            Node.trimSpaces(lexer, node);
                            Node.insertNodeAtEnd(node, node2);
                            node2 = lexer.inferredTag("br");
                            continue;
                        }
                    } else {
                        if ((node2.tag.model & 0x10) != 0 && node2.tag != TagTable.tagA && (node2.tag.model & 0x800) == 0 && (node.tag.model & 0x10) != 0) {
                            lexer.popInline(node);
                            if (node.tag != TagTable.tagA) {
                                if (node2.tag == TagTable.tagA && node2.tag != node.tag) {
                                    Report.warning(lexer, node, node2, (short)2);
                                    lexer.ungetToken();
                                } else {
                                    Report.warning(lexer, node, node2, (short)5);
                                }
                                if ((s & 2) == 0) {
                                    Node.trimSpaces(lexer, node);
                                }
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            Report.warning(lexer, node, node2, (short)3);
                            continue;
                        }
                        if (lexer.exiled && node2.tag.model != 0 && (node2.tag.model & 0x80) != 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    }
                }
                if ((node2.tag.model & 0x4000) != 0 && (node.tag.model & 0x4000) != 0) {
                    if (node2.tag == node.tag) {
                        Report.warning(lexer, node, node2, (short)5);
                    } else {
                        Report.warning(lexer, node, node2, (short)2);
                        lexer.ungetToken();
                    }
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == TagTable.tagA && !node2.implicit && lexer.isPushed(node2)) {
                    if (node2.attributes == null) {
                        node2.type = (short)6;
                        Report.warning(lexer, node, node2, (short)19);
                        lexer.popInline(node2);
                        lexer.ungetToken();
                        continue;
                    }
                    lexer.ungetToken();
                    Report.warning(lexer, node, node2, (short)2);
                    lexer.popInline(node);
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if ((node.tag.model & 0x4000) != 0) {
                    if (node2.tag == TagTable.tagCenter || node2.tag == TagTable.tagDiv) {
                        if (node2.type != 5 && node2.type != 7) {
                            Report.warning(lexer, node, node2, (short)3);
                            continue;
                        }
                        Report.warning(lexer, node, node2, (short)6);
                        if (node.content == null) {
                            Node.insertNodeAsParent(node, node2);
                            continue;
                        }
                        Node.insertNodeAfterElement(node, node2);
                        if ((s & 2) == 0) {
                            Node.trimSpaces(lexer, node);
                        }
                        node = lexer.cloneNode(node);
                        node.start = lexer.lexsize;
                        node.end = lexer.lexsize;
                        Node.insertNodeAtEnd(node2, node);
                        continue;
                    }
                    if (node2.tag == TagTable.tagHr) {
                        if (node2.type != 5 && node2.type != 7) {
                            Report.warning(lexer, node, node2, (short)3);
                            continue;
                        }
                        Report.warning(lexer, node, node2, (short)6);
                        if (node.content == null) {
                            Node.insertNodeBeforeElement(node, node2);
                            continue;
                        }
                        Node.insertNodeAfterElement(node, node2);
                        if ((s & 2) == 0) {
                            Node.trimSpaces(lexer, node);
                        }
                        node = lexer.cloneNode(node);
                        node.start = lexer.lexsize;
                        node.end = lexer.lexsize;
                        Node.insertNodeAfterElement(node2, node);
                        continue;
                    }
                }
                if (node.tag == TagTable.tagDt && node2.tag == TagTable.tagHr) {
                    if (node2.type != 5 && node2.type != 7) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    Report.warning(lexer, node, node2, (short)6);
                    node3 = lexer.inferredTag("dd");
                    if (node.content == null) {
                        Node.insertNodeBeforeElement(node, node3);
                        Node.insertNodeAtEnd(node3, node2);
                        continue;
                    }
                    Node.insertNodeAfterElement(node, node3);
                    Node.insertNodeAtEnd(node3, node2);
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    node = lexer.cloneNode(node);
                    node.start = lexer.lexsize;
                    node.end = lexer.lexsize;
                    Node.insertNodeAfterElement(node3, node);
                    continue;
                }
                if (node2.type == 6) {
                    Node node4 = node.parent;
                    while (node4 != null) {
                        if (node2.tag == node4.tag) {
                            if ((node.tag.model & 0x8000) == 0 && !node.implicit) {
                                Report.warning(lexer, node, node2, (short)2);
                            }
                            if (node.tag == TagTable.tagA) {
                                lexer.popInline(node);
                            }
                            lexer.ungetToken();
                            if ((s & 2) == 0) {
                                Node.trimSpaces(lexer, node);
                            }
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node4 = node4.parent;
                    }
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5) {
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if ((node.tag.model & 0x8000) == 0) {
                        Report.warning(lexer, node, node2, (short)2);
                    }
                    if ((node2.tag.model & 4) != 0 && (node2.tag.model & 8) == 0) {
                        ParserImpl.moveToHead(lexer, node, node2);
                        continue;
                    }
                    if (node.tag == TagTable.tagA) {
                        if (node2.tag != null && (node2.tag.model & 0x4000) == 0) {
                            lexer.popInline(node);
                        } else if (node.content == null) {
                            Node.discardElement(node);
                            lexer.ungetToken();
                            return;
                        }
                    }
                    lexer.ungetToken();
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.implicit) {
                        Report.warning(lexer, node, node2, (short)10);
                    }
                    if (node2.tag == TagTable.tagBr) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, s);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            if ((node.tag.model & 0x8000) == 0) {
                Report.warning(lexer, node, node2, (short)1);
            }
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseFrameSet
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            lexer.badAccess = (short)(lexer.badAccess | 0x10);
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if ((node2.type == 5 || node2.type == 7) && node2.tag != null && (node2.tag.model & 4) != 0) {
                    ParserImpl.moveToHead(lexer, node, node2);
                    continue;
                }
                if (node2.tag == TagTable.tagBody) {
                    lexer.ungetToken();
                    node2 = lexer.inferredTag("noframes");
                    Report.warning(lexer, node, node2, (short)10);
                }
                if (node2.type == 5 && (node2.tag.model & 0x2000) != 0) {
                    Node.insertNodeAtEnd(node, node2);
                    lexer.excludeBlocks = false;
                    ParserImpl.parseTag(lexer, node2, (short)1);
                    continue;
                }
                if (node2.type == 7 && (node2.tag.model & 0x2000) != 0) {
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            Report.warning(lexer, node, node2, (short)1);
        }
    }

    public static class ParseBody
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            s = 0;
            boolean bl = true;
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    lexer.seenBodyEndTag = 1;
                    s = 0;
                    if (node.parent.tag != TagTable.tagNoframes) continue;
                    break;
                }
                if (node2.tag == TagTable.tagNoframes) {
                    if (node2.type == 5) {
                        Node.insertNodeAtEnd(node, node2);
                        ParserImpl.getParseBlock().parse(lexer, node2, s);
                        continue;
                    }
                    if (node2.type == 6 && node.parent.tag == TagTable.tagNoframes) {
                        Node.trimSpaces(lexer, node);
                        lexer.ungetToken();
                        break;
                    }
                }
                if ((node2.tag == TagTable.tagFrame || node2.tag == TagTable.tagFrameset) && node.parent.tag == TagTable.tagNoframes) {
                    Node.trimSpaces(lexer, node);
                    lexer.ungetToken();
                    break;
                }
                if (node2.tag == TagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                boolean bl2 = false;
                if (node2.type == 4 && node2.end <= node2.start + 1 && node2.textarray[node2.start] == 32) {
                    bl2 = true;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (lexer.seenBodyEndTag == 1 && !bl2) {
                    ++lexer.seenBodyEndTag;
                    Report.warning(lexer, node, node2, (short)22);
                }
                if (node2.type == 4) {
                    if (bl2 && s == 0) continue;
                    if (lexer.configuration.EncloseBodyText && !bl2) {
                        lexer.ungetToken();
                        Node node3 = lexer.inferredTag("p");
                        Node.insertNodeAtEnd(node, node3);
                        ParserImpl.parseTag(lexer, node3, s);
                        s = 1;
                        continue;
                    }
                    lexer.versions = (short)(lexer.versions & 0xFFFFFFFA);
                    if (bl) {
                        bl = false;
                        if (lexer.inlineDup(node2) > 0) continue;
                    }
                    Node.insertNodeAtEnd(node, node2);
                    s = 1;
                    continue;
                }
                if (node2.type == 1) {
                    Node.insertDocType(lexer, node, node2);
                    continue;
                }
                if (node2.tag == null || node2.tag == TagTable.tagParam) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                lexer.excludeBlocks = false;
                if ((node2.tag.model & 8) == 0 && (node2.tag.model & 0x10) == 0) {
                    if ((node2.tag.model & 4) == 0) {
                        Report.warning(lexer, node, node2, (short)6);
                    }
                    if ((node2.tag.model & 2) != 0) {
                        if (node2.tag != TagTable.tagBody || !node.implicit || node.attributes != null) continue;
                        node.attributes = node2.attributes;
                        node2.attributes = null;
                        continue;
                    }
                    if ((node2.tag.model & 4) != 0) {
                        ParserImpl.moveToHead(lexer, node, node2);
                        continue;
                    }
                    if ((node2.tag.model & 0x20) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("ul");
                        Node.addClass(node2, "noindent");
                        lexer.excludeBlocks = true;
                    } else if ((node2.tag.model & 0x40) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("dl");
                        lexer.excludeBlocks = true;
                    } else if ((node2.tag.model & 0x380) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("table");
                        lexer.excludeBlocks = true;
                    } else {
                        if ((node2.tag.model & 0x600) != 0) continue;
                        lexer.ungetToken();
                        return;
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == TagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == TagTable.tagP) {
                        Node.coerceNode(lexer, node2, TagTable.tagBr);
                        Node.insertNodeAtEnd(node, node2);
                        node2 = lexer.inferredTag("br");
                    } else if ((node2.tag.model & 0x10) != 0) {
                        lexer.popInline(node2);
                    }
                }
                if (node2.type == 5 || node2.type == 7) {
                    if ((node2.tag.model & 0x10) != 0 && (node2.tag.model & 0x20000) == 0) {
                        lexer.versions = node2.tag == TagTable.tagImg ? (short)(lexer.versions & 0xFFFFFFFB) : (short)(lexer.versions & 0xFFFFFFFA);
                        if (bl && !node2.implicit) {
                            bl = false;
                            if (lexer.inlineDup(node2) > 0) continue;
                        }
                        s = 1;
                    } else {
                        bl = true;
                        s = 0;
                    }
                    if (node2.implicit) {
                        Report.warning(lexer, node, node2, (short)10);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, s);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
        }
    }

    public static class ParseScript
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2 = lexer.getCDATA(node);
            if (node2 != null) {
                Node.insertNodeAtEnd(node, node2);
            }
        }
    }

    public static class ParseTitle
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            while ((node2 = lexer.getToken((short)1)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (node2.type == 4) {
                    if (node.content == null) {
                        Node.trimInitialSpace(lexer, node, node2);
                    }
                    if (node2.start >= node2.end) continue;
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)2);
                lexer.ungetToken();
                Node.trimSpaces(lexer, node);
                return;
            }
            Report.warning(lexer, node, node2, (short)1);
        }
    }

    public static class ParseHead
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            int n = 0;
            int n2 = 0;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    break;
                }
                if (node2.type == 4) {
                    lexer.ungetToken();
                    break;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 1) {
                    Node.insertDocType(lexer, node, node2);
                    continue;
                }
                if (node2.tag == null) {
                    Report.warning(lexer, node, node2, (short)3);
                    continue;
                }
                if ((node2.tag.model & 4) == 0) {
                    lexer.ungetToken();
                    break;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.tag == TagTable.tagTitle) {
                        if (++n > 1) {
                            Report.warning(lexer, node, node2, (short)33);
                        }
                    } else if (node2.tag == TagTable.tagBase) {
                        if (++n2 > 1) {
                            Report.warning(lexer, node, node2, (short)33);
                        }
                    } else if (node2.tag == TagTable.tagNoscript) {
                        Report.warning(lexer, node, node2, (short)6);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                Report.warning(lexer, node, node2, (short)3);
            }
            if (n == 0) {
                Report.warning(lexer, node, null, (short)12);
                Node.insertNodeAtEnd(node, lexer.inferredTag("title"));
            }
        }
    }

    public static class ParseHTML
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            block25: {
                Node node3;
                Node node4;
                block24: {
                    node4 = null;
                    node3 = null;
                    lexer.configuration.XmlTags = false;
                    lexer.seenBodyEndTag = 0;
                    while (true) {
                        if ((node2 = lexer.getToken((short)0)) == null) {
                            node2 = lexer.inferredTag("head");
                            break block24;
                        }
                        if (node2.tag == TagTable.tagHead) break block24;
                        if (node2.tag == node.tag && node2.type == 6) {
                            Report.warning(lexer, node, node2, (short)3);
                            continue;
                        }
                        if (!Node.insertMisc(node, node2)) break;
                    }
                    lexer.ungetToken();
                    node2 = lexer.inferredTag("head");
                }
                Node node5 = node2;
                Node.insertNodeAtEnd(node, node5);
                ParserImpl.getParseHead().parse(lexer, node5, s);
                block1: while (true) {
                    if ((node2 = lexer.getToken((short)0)) == null) {
                        if (node4 == null) {
                            node2 = lexer.inferredTag("body");
                        }
                        return;
                    }
                    if (node2.tag == node.tag) {
                        if (node2.type == 5 || node4 != null) continue;
                        Report.warning(lexer, node, node2, (short)3);
                        continue;
                    }
                    if (Node.insertMisc(node, node2)) continue;
                    if (node2.tag == TagTable.tagBody) {
                        if (node2.type != 5) {
                            Report.warning(lexer, node, node2, (short)3);
                            continue;
                        }
                        if (node4 != null) {
                            lexer.ungetToken();
                            if (node3 == null) {
                                node3 = lexer.inferredTag("noframes");
                                Node.insertNodeAtEnd(node4, node3);
                                Report.warning(lexer, node, node3, (short)10);
                            }
                            ParserImpl.parseTag(lexer, node3, s);
                            continue;
                        }
                        break block25;
                    }
                    if (node2.tag == TagTable.tagFrameset) {
                        if (node2.type != 5) {
                            Report.warning(lexer, node, node2, (short)3);
                            continue;
                        }
                        if (node4 != null) {
                            Report.error(lexer, node, node2, (short)13);
                        } else {
                            node4 = node2;
                        }
                        Node.insertNodeAtEnd(node, node2);
                        ParserImpl.parseTag(lexer, node2, s);
                        node2 = node4.content;
                        while (true) {
                            if (node2 == null) continue block1;
                            if (node2.tag == TagTable.tagNoframes) {
                                node3 = node2;
                            }
                            node2 = node2.next;
                        }
                    }
                    if (node2.tag == TagTable.tagNoframes) {
                        if (node2.type != 5) {
                            Report.warning(lexer, node, node2, (short)3);
                            continue;
                        }
                        if (node4 == null) {
                            Report.warning(lexer, node, node2, (short)3);
                            node2 = lexer.inferredTag("body");
                            break block25;
                        }
                        if (node3 == null) {
                            node3 = node2;
                            Node.insertNodeAtEnd(node4, node3);
                        }
                        ParserImpl.parseTag(lexer, node3, s);
                        continue;
                    }
                    if ((node2.type == 5 || node2.type == 7) && node2.tag != null && (node2.tag.model & 4) != 0) {
                        ParserImpl.moveToHead(lexer, node, node2);
                        continue;
                    }
                    lexer.ungetToken();
                    if (node4 == null) break;
                    if (node3 == null) {
                        node3 = lexer.inferredTag("noframes");
                        Node.insertNodeAtEnd(node4, node3);
                    } else {
                        Report.warning(lexer, node, node2, (short)21);
                    }
                    ParserImpl.parseTag(lexer, node3, s);
                }
                node2 = lexer.inferredTag("body");
            }
            Node.insertNodeAtEnd(node, node2);
            ParserImpl.parseTag(lexer, node2, s);
        }
    }
}

