package com.wxpn.tutorial.db;

import java.io.*;
import java.net.URL;
import java.sql.*;
import java.util.*;

/**
 * : ݿ Copyright (c) 2005-2008 Wang Xining
 * 
 * @author Ϧ
 * @version 1.0
 */

public class DB {
	static String driver = null;

	static String server = null;

	static String dbuser = null;

	static String dbpassword = null;

	static int minconn = 0;

	static int maxconn = 0;

	static double maxconntime = 0.1D;

	static String log_properties = null;

	static ConnectionPool p = null;

	private static String resourcePath;

	private static Properties configProperties = System.getProperties();

	static {
		int pos = 0;
		URL url = DB.class.getResource("DB.class");

		String pkgName = DB.class.getPackage().getName();

		do {
			pos = pkgName.indexOf(".");
			if (pos > 0) {
				pkgName = pkgName.substring(0, pos) + "/"
						+ pkgName.substring(pos + 1);
			}
		} while (pos > 0);

		String filePath = url.getFile();
		String appPath = filePath.substring(0, filePath.indexOf("/classes/"
				+ pkgName));
		resourcePath = appPath + "/resources";

		try {
			configProperties.load(new FileInputStream(DB.getResourcePath()
					+ "/config.properties"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void getAtrributes() {
		try {
			driver = getProperty("driver");
			server = getProperty("server");
			dbuser = getProperty("dbuser");
			dbpassword = getProperty("dbpassword");
			minconn = Integer.parseInt(getProperty("minconn"));
			maxconn = Integer.parseInt(getProperty("maxconn"));
			maxconntime = Double.parseDouble(getProperty("maxconntime"));
		} catch (Exception e) {
			System.out.println("Problem parsing the file:" + e);
		}

	}

	/**
	 * Create a connectionpool
	 */
	public static ConnectionPool getConnPool() {
		try {
			if (p == null) {
				getAtrributes();
				p = new ConnectionPool(driver, server, dbuser, dbpassword,
						minconn, maxconn, maxconntime);
			}
			return p;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * @return
	 */
	public static String getResourcePath() {
		return resourcePath;
	}

	/**
	 * @return
	 */
	public static Properties getConfigProperties() {
		return configProperties;
	}

	public static String getProperty(String name) {
		return getConfigProperties().getProperty(name);
	}

	public static void main(String[] args) {
		ConnectionPool connPool = DB.getConnPool();
		Connection conn = connPool.getConnection();
		Statement stmt = null;
		ResultSet rs = null;

		try {
			int nextMessageid = 0;
			String relative_path = null;

			String sql = "select * from userinfo";
			stmt = conn.createStatement();
			// stmt.addBatch(sql);
			// sql = "insert into
			// mms_user(messageid,emailid,messagename,sender,coypto,bcc,sendtime,size,totalnumber,priority,remark,content)
			// values('7','1','Fw: ıʶ
			// 57567567','<wxn1@localhost>','<12121@localhost>','','Sun Oct 03
			// 14:30:13 CST 2004','114421','2','3','','')";
			sql = new String(sql.getBytes("gb2312"), "8859_1");
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				System.out.println(rs.getString("UserName"));
			}
		} catch (SQLException sqlExc) {
			sqlExc.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rs != null) {
					rs.close();
				}
				if (stmt != null) {
					stmt.close();
				}
				connPool.freeConnection(conn);
				System.out.println("free connection!");
			} catch (SQLException sqlExc) {
				sqlExc.printStackTrace();
			}

		}
	}

}
