package com.wxpn.tutorial.ec.servlet;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wxpn.tutorial.ec.bean.ECBook;
import com.wxpn.tutorial.ec.bean.ECBookMgr;
import com.wxpn.tutorial.ec.util.Encoder;

/**
 * Servlet implementation class for Servlet: ComposeServlet
 */
public class ComposeServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public ComposeServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		String name,author,content,category,publish_name,publish_address;
		String language,commend,price,stock;
		String cdrom,discount;
		name=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("name")));
		author=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("author")));
		content=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("content")));
		category=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("category")));
		publish_name=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("publish_name")));
		publish_address=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("publish_address")));
		language=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("language")));
		commend=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("commend")));
		price=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("price1")+"."+request.getParameter("price2")));
		stock=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("book_number")));
		cdrom=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("cdrom")));
		discount=Encoder.returnToBr(Encoder.returnToHTML(request.getParameter("good_price")));

		ECBook book = new ECBook();
		book.setAuthor(author);
		book.setCategory(Integer.parseInt(category));
		book.setCdrom(Integer.parseInt(cdrom));
		book.setCommend(Integer.parseInt(commend));
		book.setContent(content);
		book.setDiscount(Integer.parseInt(discount));
		book.setLanguage(language);
		book.setName(name);
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		book.setStr_on_sale_time(formatter.format(new Date()));
		book.setPrice(Double.parseDouble(price));
		book.setPublish_address(publish_address);
		book.setPublish_name(publish_name);
		book.setStock(Integer.parseInt(stock));
		
		ECBookMgr mgr = new ECBookMgr();

		int i = mgr.add(book);
		if (i == 1) {
			// ׫дɹ
			int pagesize = 10;
			int count = mgr.getCount();// ¼
			int totalPageNum = count / pagesize;// ߼ҳ
			// ¼ÿҳʾ,0,ô
			// ߼ҳӦΪ+1
			if ((count % pagesize) > 0) {
				totalPageNum += 1;
			}

			request.setAttribute("totalPageNum", new Integer(totalPageNum));
			Collection c = mgr.getAll(pagesize, 1);
			request.setAttribute("c", c);
			try {
				request.getRequestDispatcher("/book_store/index.jsp").forward(
						request, response);
			} catch (Throwable t) {
				getServletContext().log(t.getMessage());
			}
		}
	}
}