package com.wxpn.tutorial.ec.servlet;

import java.io.IOException;
import java.util.Collection;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wxpn.tutorial.ec.bean.ECOrder;
import com.wxpn.tutorial.ec.bean.ECOrderMgr;

/**
 * Servlet implementation class for Servlet: UserListServlet
 */
public class OrderHandlerServlet extends javax.servlet.http.HttpServlet
		implements javax.servlet.Servlet {
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public OrderHandlerServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setHeader("Pragma", "No-cache");
		response.setHeader("Cache-Control", "no-cache");
		response.setDateHeader("Expires", 0);

		if (request.getSession().getAttribute("username") == null) {
			response.sendRedirect("/ECommerce/member/login.jsp");
		} else {
			String id = request.getParameter("id");

			ECOrderMgr mgr = new ECOrderMgr();
			mgr.update(Integer.parseInt(id));

			request.setAttribute("order", mgr.get(Integer.parseInt(id)));
			try {
				request.getRequestDispatcher("OrderAdminServlet").forward(
						request, response);
			} catch (Throwable t) {
				getServletContext().log(t.getMessage());
			}
		}
	}
}